#include "scripts.h"
#include "engine.h"
#include "jfw4.h"

void JFW_Spawn_Timer::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("SpawnCustom"))
	{
		Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNum"));
	}
}
void JFW_Spawn_Timer::Timer_Expired(GameObject * obj,int number)
{
	Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("TriggerID")),Get_Int_Parameter("TriggerCustom"),0,0);
	Commands->Create_Object(Get_Parameter("SpawnPreset"),Get_Vector3_Parameter("SpawnLocation"));
}
void JFW_Death_Destroy_Object_Delay::Killed(GameObject * obj,GameObject * shooter)
{
	Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNum"));
}
void JFW_Death_Destroy_Object_Delay::Timer_Expired(GameObject * obj,int number)
{
	Commands->Destroy_Object(Commands->Find_Object(Get_Int_Parameter("ID")));
}
void JFW_Conyard::Created(GameObject * obj)
{
	disabled = false;
	Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNum"));
}
void JFW_Conyard::Killed(GameObject * obj,GameObject * shooter)
{
	disabled = true;
}
void JFW_Conyard::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("DisableCustom"))
	{
		disabled = true;
	}
}
void JFW_Conyard::Timer_Expired(GameObject * obj,int number)
{
	if (disabled == false)
	{
		Repair_All_Buildings_By_Team(Get_Object_Type(obj),Commands->Get_ID(obj),Get_Float_Parameter("Health"));
		Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNum"));
	}
}
void JFW_Conyard::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&disabled);
}
void JFW_Character_Buy::Entered(GameObject * obj,GameObject * enter)
{
	const char *preset;
	int x;
	int cost;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,x) != 0)
	{
		return;
	}
	preset = Get_Parameter("Preset_Name");
	cost = Get_Int_Parameter("Cost");
	if (cost <= Commands->Get_Money(enter))
	{
		cost = -cost;
		Commands->Give_Money(enter,(float)cost,0);
		Change_Character(enter,preset);
	}
}
void JFW_Zone_Character::Entered(GameObject * obj,GameObject * enter)
{
	const char *preset;
	int x;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,x) != 0)
	{
		return;
	}
	preset = Get_Parameter("Preset_Name");
	Change_Character(enter,preset);
}
void JFW_Teleport_Zone_Team::Entered(GameObject * obj, GameObject * enter)
{
	Vector3 spawn_position;
	spawn_position = Get_Vector3_Parameter("Location");
	int team;
	team = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,team) != 0)
	{
		return;
	}
	int x = Get_Int_Parameter("Object_ID");
	if (x != 0)
	{
		GameObject * gotoObject = Commands->Find_Object(x);
		Vector3 gotoLocation = Commands->Get_Position(gotoObject);
		Commands->Set_Position(enter,gotoLocation);
	}
	else
		Commands->Set_Position(enter,spawn_position);
}
void JFW_Create_Destroy_Object_On_Enter::Entered(GameObject * obj, GameObject * enter)
{
	int team;
	team = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,team) != 0)
	{
		return;
	}
	GameObject *object = Commands->Create_Object(Get_Parameter("Preset"),Get_Vector3_Parameter("Location"));
	Commands->Set_Facing(object,Get_Float_Parameter("Facing"));
	ObjectID = Commands->Get_ID(object);
}
void JFW_Create_Destroy_Object_On_Enter::Exited(GameObject * obj, GameObject * exit)
{
	int team;
	team = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(exit,team) != 0)
	{
		return;
	}
	Commands->Destroy_Object(Commands->Find_Object(ObjectID));
	ObjectID = 0;
}
void JFW_Create_Destroy_Object_On_Enter::Created(GameObject * obj)
{
	ObjectID = 0;
}
void JFW_Create_Destroy_Object_On_Enter::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&ObjectID);
}
void JFW_Custom_Send_Ordered_Customs::Created(GameObject * obj)
{
	CurrentCustom = 0;
}
void JFW_Custom_Send_Ordered_Customs::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("WaitCustom"))
	{
		Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter(CurrentCustom)),Get_Int_Parameter(CurrentCustom+8),0,0);
		CurrentCustom++;
		if (CurrentCustom > 7)
		{
			CurrentCustom = 0;
		}
	}
}
void JFW_Custom_Send_Ordered_Customs::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&CurrentCustom);
}
void JFW_Custom_Send_Customs::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("WaitCustom"))
	{
		for (int CurrentCustom=0;CurrentCustom<=7;CurrentCustom++)
		{
			Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter(CurrentCustom)),Get_Int_Parameter(CurrentCustom+8),0,0);
		}
	}
}
void JFW_Custom_Send_Custom_Multiple_IDs::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("WaitCustom"))
	{
		for (int CurrentCustom=0;CurrentCustom<=7;CurrentCustom++)
		{
			Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter(CurrentCustom)),Get_Int_Parameter("SendCustom"),0,0);
		}
	}
}
void JFW_Set_Health_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Custom"))
	{
		Commands->Set_Health(obj,Get_Float_Parameter("Value"));
	}
}
void JFW_Add_Health_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Custom"))
	{
		Commands->Set_Health(obj,Commands->Get_Health(obj)+Get_Float_Parameter("Value"));
	}
}
void JFW_Set_Max_Health_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Custom"))
	{
		Set_Max_Health(obj,Get_Float_Parameter("Value"));
	}
}
void JFW_Add_Max_Health_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Custom"))
	{
		Set_Max_Health(obj,Commands->Get_Max_Health(obj)+Get_Float_Parameter("Value"));
	}
}
void JFW_Set_Shield_Strength_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Custom"))
	{
		Commands->Set_Shield_Strength(obj,Get_Float_Parameter("Value"));
	}
}
void JFW_Add_Shield_Strength_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Custom"))
	{
		Commands->Set_Shield_Strength(obj,Commands->Get_Shield_Strength(obj)+Get_Float_Parameter("Value"));
	}
}
void JFW_Set_Max_Shield_Strength_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Custom"))
	{
		Set_Max_Shield_Strength(obj,Get_Float_Parameter("Value"));
	}
}
void JFW_Add_Max_Shield_Strength_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Custom"))
	{
		Set_Max_Shield_Strength(obj,Commands->Get_Max_Shield_Strength(obj)+Get_Float_Parameter("Value"));
	}
}
void JFW_Set_Health_On_Custom_Sender::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Custom"))
	{
		Commands->Set_Health(sender,Get_Float_Parameter("Value"));
	}
}
void JFW_Add_Health_On_Custom_Sender::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Custom"))
	{
		Commands->Set_Health(sender,Commands->Get_Health(sender)+Get_Float_Parameter("Value"));
	}
}
void JFW_Set_Max_Health_On_Custom_Sender::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Custom"))
	{
		Set_Max_Health(sender,Get_Float_Parameter("Value"));
	}
}
void JFW_Add_Max_Health_On_Custom_Sender::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Custom"))
	{
		Set_Max_Health(sender,Commands->Get_Max_Health(sender)+Get_Float_Parameter("Value"));
	}
}
void JFW_Set_Shield_Strength_On_Custom_Sender::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Custom"))
	{
		Commands->Set_Shield_Strength(sender,Get_Float_Parameter("Value"));
	}
}
void JFW_Add_Shield_Strength_On_Custom_Sender::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Custom"))
	{
		Commands->Set_Shield_Strength(sender,Commands->Get_Shield_Strength(sender)+Get_Float_Parameter("Value"));
	}
}
void JFW_Set_Max_Shield_Strength_On_Custom_Sender::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Custom"))
	{
		Set_Max_Shield_Strength(sender,Get_Float_Parameter("Value"));
	}
}
void JFW_Add_Max_Shield_Strength_On_Custom_Sender::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Custom"))
	{
		Set_Max_Shield_Strength(sender,Commands->Get_Max_Shield_Strength(sender)+Get_Float_Parameter("Value"));
	}
}
void JFW_Create_Destroy_Object_On_Custom_Death::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("CreateMessage"))
	{
		GameObject *object = Commands->Create_Object(Get_Parameter("Preset"),Get_Vector3_Parameter("Location"));
		Commands->Set_Facing(object,Get_Float_Parameter("Facing"));
		ObjectID = Commands->Get_ID(object);
	}
	if (message == Get_Int_Parameter("DestroyMessage"))
	{
		Commands->Destroy_Object(Commands->Find_Object(ObjectID));
		ObjectID = 0;
	}
}
void JFW_Create_Destroy_Object_On_Custom_Death::Created(GameObject * obj)
{
	ObjectID = 0;
}
void JFW_Create_Destroy_Object_On_Custom_Death::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&ObjectID);
}
void JFW_Create_Destroy_Object_On_Custom_Death_Bone::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("CreateMessage"))
	{
		GameObject *object = Commands->Create_Object(Get_Parameter("Preset"),Get_Vector3_Parameter("Location"));
		Commands->Set_Facing(object,Get_Float_Parameter("Facing"));
		Commands->Attach_To_Object_Bone(object,obj,Get_Parameter("BoneName"));
		ObjectID = Commands->Get_ID(object);
	}
	if (message == Get_Int_Parameter("DestroyMessage"))
	{
		Commands->Destroy_Object(Commands->Find_Object(ObjectID));
	}
}
void JFW_Create_Destroy_Object_On_Custom_Death_Bone::Created(GameObject * obj)
{
	ObjectID = 0;
}
void JFW_Create_Destroy_Object_On_Custom_Death_Bone::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&ObjectID);
}
void JFW_Create_Destroy_Object_On_Custom_Death_Bone::Killed(GameObject * obj,GameObject * shooter)
{
	Commands->Destroy_Object(Commands->Find_Object(ObjectID));
}
void JFW_Create_Destroy_Object_On_Custom_Death::Killed(GameObject * obj,GameObject * shooter)
{
	Commands->Destroy_Object(Commands->Find_Object(ObjectID));
}
void JFW_Custom_Destroy_All_Buildings::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	Kill_All_Buildings_By_Team(Get_Int_Parameter("Player_Type"));
}
void JFW_Random_Timer_Play_Cinematic::Created(GameObject * obj)
{
	float timertimemin;
	float timertimemax;
	float timertime;
	int timernumber;
	timertimemin = Get_Float_Parameter("TimeMin");
	timertimemax = Get_Float_Parameter("TimeMax");
	timertime = Commands->Get_Random(timertimemin,timertimemax);
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
}
void JFW_Random_Timer_Play_Cinematic::Timer_Expired(GameObject * obj,int number)
{
	int timernumber;
	int repeat;
	float timertimemin;
	float timertimemax;
	float timertime;
	const char *scriptname;
	Vector3 position;
	GameObject * object;
	float facing;
	timertimemin = Get_Float_Parameter("TimeMin");
	timertimemax = Get_Float_Parameter("TimeMax");
	timertime = Commands->Get_Random(timertimemin,timertimemax);
	timernumber = Get_Int_Parameter("TimerNum");
	repeat = Get_Int_Parameter("Repeat");
	scriptname = Get_Parameter("Script_Name");
	position = Get_Vector3_Parameter("location");
	facing = Get_Float_Parameter("Facing");
	if (number == timernumber)
	{
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		if (repeat == 1)
		{	
			Commands->Start_Timer(obj,this,timertime,timernumber);
		}
	}
}
void JFW_Flying_Infantry::Created(GameObject * obj)
{
	Toggle_Fly_Mode(obj);
}
void JFW_Flying_Infantry_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Toggle_Fly_Mode(obj);
	}
}
void JFW_Flying_Infantry_Powerup::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == CUSTOM_EVENT_POWERUP)
	{
		Toggle_Fly_Mode(sender);
	}
}
void JFW_Flying_Infantry_Enter::Entered(GameObject * obj,GameObject * enter)
{
	int x;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,x) != 0)
	{
		return;
	}
	Toggle_Fly_Mode(enter);
}
void JFW_Flying_Infantry_Exit::Exited(GameObject * obj, GameObject * exit)
{
	int x;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(exit,x) != 0)
	{
		return;
	}
	Toggle_Fly_Mode(exit);
}
void JFW_Warp_On_Pickup_Team::Custom(GameObject *obj, int message, int param, GameObject *sender)
{
	if (message == CUSTOM_EVENT_POWERUP)
	{
		int x;
		x = Get_Int_Parameter("Player_Type");
		if (CheckPlayerType(sender,x) != 0)
		{
			return;
		}
		Vector3 WarpPosition = Get_Vector3_Parameter("Position");
		Commands->Set_Position(sender,WarpPosition);
	}
}
void JFW_Base_Defence_No_VTOL::Created(GameObject * obj)
{
	Vector3 pos,pos1,pos2,pos3;
	GameObject * object;
	objtype = Commands->Get_Player_Type(obj);
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	pos = Commands->Get_Position(obj);
	pos1.X = pos.X - 10;
	pos1.Y = pos.Y - 10;
	pos1.Z = pos.Z + 2;
	pos2.X = pos.X + 10;
	pos2.Y = pos.Y;
	pos2.Z = pos.Z + 2;
	pos3.X = pos.X + 10;
	pos3.Y = pos.Y - 10;
	pos3.Z = pos.Z + 2;
	object = Commands->Create_Object("Invisible_Object", pos1);
	if (object)
		id1 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos2);
	if (object)
		id2 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos3);
	if (object)
		id3 = Commands->Get_ID(object);
	Commands->Start_Timer(obj, this, 10, 1);
}
void JFW_Base_Defence_No_VTOL::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (!Is_VTOLVehicle(seen))
	{
		ActionParamsStruct params;
		Vector3 pos,pos2;
		float distance;
		float minattack,maxattack;
		float attacktimer;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		distance = Commands->Get_Distance(pos2,pos);
		minattack = Get_Float_Parameter("MinAttackDistance");
		if (distance >= minattack)
		{
			maxattack = Get_Float_Parameter("MaxAttackDistance");
			params.Set_Basic(this,100,2,-1);
			params.Set_Attack_Hold(seen,maxattack,0.0,true,false);
			Commands->Action_Attack(obj,params);
			attacktimer = Get_Float_Parameter("AttackTimer");
			Commands->Start_Timer(obj,this,attacktimer,2);
		}
	}
}
void JFW_Base_Defence_No_VTOL::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	if (action == 2)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_Base_Defence_No_VTOL::Timer_Expired(GameObject * obj,int number)
{
	ActionParamsStruct var;
	GameObject * object;
	float f;
	switch (number)
	{
	case 1:
		f = Commands->Get_Random(0.0f, 2.9999f);
		switch (__min(int(f), 2))
		{
		case 0:
			object = Commands->Find_Object(id1);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		case 1:
			object = Commands->Find_Object(id2);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		default:
			object = Commands->Find_Object(id3);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
		}
	Commands->Start_Timer(obj, this, 10, 1);
	break;
	case 2:
		Commands->Action_Reset(obj, 100);
		break;
	}
}
void JFW_Base_Defence_No_VTOL::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&id1);
	Auto_Save_Variable(2,4,&id2);
	Auto_Save_Variable(3,4,&id3);
	Auto_Save_Variable(4,4,&objtype);
}
void JFW_Base_Defence_VTOL_Only::Created(GameObject * obj)
{
	Vector3 pos,pos1,pos2,pos3;
	GameObject * object;
	objtype = Commands->Get_Player_Type(obj);
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	pos = Commands->Get_Position(obj);
	pos1.X = pos.X - 10;
	pos1.Y = pos.Y - 10;
	pos1.Z = pos.Z + 2;
	pos2.X = pos.X + 10;
	pos2.Y = pos.Y;
	pos2.Z = pos.Z + 2;
	pos3.X = pos.X + 10;
	pos3.Y = pos.Y - 10;
	pos3.Z = pos.Z + 2;
	object = Commands->Create_Object("Invisible_Object", pos1);
	if (object)
		id1 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos2);
	if (object)
		id2 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos3);
	if (object)
		id3 = Commands->Get_ID(object);
	Commands->Start_Timer(obj, this, 10, 1);
}
void JFW_Base_Defence_VTOL_Only::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (Is_VTOLVehicle(seen))
	{
		ActionParamsStruct params;
		Vector3 pos,pos2;
		float distance;
		float minattack,maxattack;
		float attacktimer;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		distance = Commands->Get_Distance(pos2,pos);
		minattack = Get_Float_Parameter("MinAttackDistance");
		if (distance >= minattack)
		{
			maxattack = Get_Float_Parameter("MaxAttackDistance");
			params.Set_Basic(this,100,2,-1);
			params.Set_Attack_Hold(seen,maxattack,0.0,true,false);
			Commands->Action_Attack(obj,params);
			attacktimer = Get_Float_Parameter("AttackTimer");
			Commands->Start_Timer(obj,this,attacktimer,2);
		}
	}
}
void JFW_Base_Defence_VTOL_Only::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	if (action == 2)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_Base_Defence_VTOL_Only::Timer_Expired(GameObject * obj,int number)
{
	ActionParamsStruct var;
	GameObject * object;
	float f;
	switch (number)
	{
	case 1:
		f = Commands->Get_Random(0.0f, 2.9999f);
		switch (__min(int(f), 2))
		{
		case 0:
			object = Commands->Find_Object(id1);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		case 1:
			object = Commands->Find_Object(id2);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		default:
			object = Commands->Find_Object(id3);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
		}
	Commands->Start_Timer(obj, this, 10, 1);
	break;
	case 2:
		Commands->Action_Reset(obj, 100);
		break;
	}
}
void JFW_Base_Defence_VTOL_Only::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&id1);
	Auto_Save_Variable(2,4,&id2);
	Auto_Save_Variable(3,4,&id3);
	Auto_Save_Variable(4,4,&objtype);
}
void JFW_Base_Defence_No_VTOL_Secondary::Created(GameObject * obj)
{
	Vector3 pos,pos1,pos2,pos3;
	GameObject * object;
	primary = true;
	objtype = Commands->Get_Player_Type(obj);
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	pos = Commands->Get_Position(obj);
	pos1.X = pos.X - 10;
	pos1.Y = pos.Y - 10;
	pos1.Z = pos.Z + 2;
	pos2.X = pos.X + 10;
	pos2.Y = pos.Y;
	pos2.Z = pos.Z + 2;
	pos3.X = pos.X + 10;
	pos3.Y = pos.Y - 10;
	pos3.Z = pos.Z + 2;
	object = Commands->Create_Object("Invisible_Object", pos1);
	if (object)
		id1 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos2);
	if (object)
		id2 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos3);
	if (object)
		id3 = Commands->Get_ID(object);
	Commands->Start_Timer(obj, this, 10, 1);
}
void JFW_Base_Defence_No_VTOL_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (!Is_VTOLVehicle(seen))
	{
		ActionParamsStruct params;
		Vector3 pos,pos2;
		float distance;
		float minattack,maxattack;
		float attacktimer;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		distance = Commands->Get_Distance(pos2,pos);
		minattack = Get_Float_Parameter("MinAttackDistance");
		if (distance >= minattack)
		{
			maxattack = Get_Float_Parameter("MaxAttackDistance");
			params.Set_Basic(this,100,2,-1);
			params.Set_Attack_Hold(seen,maxattack,0.0,primary,false);
			Commands->Action_Attack(obj,params);
			attacktimer = Get_Float_Parameter("AttackTimer");
			Commands->Start_Timer(obj,this,attacktimer,2);
			if (primary == true)
			{
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Base_Defence_No_VTOL_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	if (action == 2)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_Base_Defence_No_VTOL_Secondary::Timer_Expired(GameObject * obj,int number)
{
	ActionParamsStruct var;
	GameObject * object;
	float f;
	switch (number)
	{
	case 1:
		f = Commands->Get_Random(0.0f, 2.9999f);
		switch (__min(int(f), 2))
		{
		case 0:
			object = Commands->Find_Object(id1);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		case 1:
			object = Commands->Find_Object(id2);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		default:
			object = Commands->Find_Object(id3);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
		}
	Commands->Start_Timer(obj, this, 10, 1);
	break;
	case 2:
		Commands->Action_Reset(obj, 100);
		break;
	}
}
void JFW_Base_Defence_No_VTOL_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&id1);
	Auto_Save_Variable(2,4,&id2);
	Auto_Save_Variable(3,4,&id3);
	Auto_Save_Variable(4,4,&objtype);
	Auto_Save_Variable(5,1,&primary);
}
void JFW_Base_Defence_VTOL_Only_Secondary::Created(GameObject * obj)
{
	Vector3 pos,pos1,pos2,pos3;
	GameObject * object;
	primary = true;
	objtype = Commands->Get_Player_Type(obj);
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	pos = Commands->Get_Position(obj);
	pos1.X = pos.X - 10;
	pos1.Y = pos.Y - 10;
	pos1.Z = pos.Z + 2;
	pos2.X = pos.X + 10;
	pos2.Y = pos.Y;
	pos2.Z = pos.Z + 2;
	pos3.X = pos.X + 10;
	pos3.Y = pos.Y - 10;
	pos3.Z = pos.Z + 2;
	object = Commands->Create_Object("Invisible_Object", pos1);
	if (object)
		id1 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos2);
	if (object)
		id2 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos3);
	if (object)
		id3 = Commands->Get_ID(object);
	Commands->Start_Timer(obj, this, 10, 1);
}
void JFW_Base_Defence_VTOL_Only_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (Is_VTOLVehicle(seen))
	{
		ActionParamsStruct params;
		Vector3 pos,pos2;
		float distance;
		float minattack,maxattack;
		float attacktimer;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		distance = Commands->Get_Distance(pos2,pos);
		minattack = Get_Float_Parameter("MinAttackDistance");
		if (distance >= minattack)
		{
			maxattack = Get_Float_Parameter("MaxAttackDistance");
			params.Set_Basic(this,100,2,-1);
			params.Set_Attack_Hold(seen,maxattack,0.0,primary,false);
			Commands->Action_Attack(obj,params);
			attacktimer = Get_Float_Parameter("AttackTimer");
			Commands->Start_Timer(obj,this,attacktimer,2);
			if (primary == true)
			{
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Base_Defence_VTOL_Only_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	if (action == 2)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_Base_Defence_VTOL_Only_Secondary::Timer_Expired(GameObject * obj,int number)
{
	ActionParamsStruct var;
	GameObject * object;
	float f;
	switch (number)
	{
	case 1:
		f = Commands->Get_Random(0.0f, 2.9999f);
		switch (__min(int(f), 2))
		{
		case 0:
			object = Commands->Find_Object(id1);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		case 1:
			object = Commands->Find_Object(id2);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		default:
			object = Commands->Find_Object(id3);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
		}
	Commands->Start_Timer(obj, this, 10, 1);
	break;
	case 2:
		Commands->Action_Reset(obj, 100);
		break;
	}
}
void JFW_Base_Defence_VTOL_Only_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&id1);
	Auto_Save_Variable(2,4,&id2);
	Auto_Save_Variable(3,4,&id3);
	Auto_Save_Variable(4,4,&objtype);
	Auto_Save_Variable(5,1,&primary);
}
void JFW_Base_Defence_Animated_No_VTOL::Created(GameObject * obj)
{
	popup = false;
	attack = false;
	Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,0,false);
	Commands->Enable_Enemy_Seen(obj,true);
}
void JFW_Base_Defence_Animated_No_VTOL::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (!Is_VTOLVehicle(seen))
	{
		if (popup == false)
		{
			popup = true;
			Commands->Start_Timer(obj,this,Get_Float_Parameter("PopupTime"),2);
			Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,Get_Float_Parameter("LastFrame"),false);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("AttackTimer"),1);
		}
		else if (attack == true)
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack_Hold(seen,Get_Float_Parameter("MaxAttackDistance"),0,true,false);
			Commands->Action_Attack(obj,params);
		}
	}
}
void JFW_Base_Defence_Animated_No_VTOL::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}
void JFW_Base_Defence_Animated_No_VTOL::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		popup = false;
		attack = false;
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,Get_Float_Parameter("LastFrame"),0,false);
		Commands->Action_Reset(obj,100);
	}
	if (number == 2)
	{
		attack = true;
	}
}
void JFW_Base_Defence_Animated_No_VTOL::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&popup);
	Auto_Save_Variable(2,1,&attack);
}
void JFW_Base_Defence_Animated_VTOL_Only::Created(GameObject * obj)
{
	popup = false;
	attack = false;
	Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,0,false);
	Commands->Enable_Enemy_Seen(obj,true);
}
void JFW_Base_Defence_Animated_VTOL_Only::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (Is_VTOLVehicle(seen))
	{
		if (popup == false)
		{
			popup = true;
			Commands->Start_Timer(obj,this,Get_Float_Parameter("PopupTime"),2);
			Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,Get_Float_Parameter("LastFrame"),false);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("AttackTimer"),1);
		}
		else if (attack == true)
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack_Hold(seen,Get_Float_Parameter("MaxAttackDistance"),0,true,false);
			Commands->Action_Attack(obj,params);
		}
	}
}
void JFW_Base_Defence_Animated_VTOL_Only::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}
void JFW_Base_Defence_Animated_VTOL_Only::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		popup = false;
		attack = false;
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,Get_Float_Parameter("LastFrame"),0,false);
		Commands->Action_Reset(obj,100);
	}
	if (number == 2)
	{
		attack = true;
	}
}
void JFW_Base_Defence_Animated_VTOL_Only::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&popup);
	Auto_Save_Variable(2,1,&attack);
}
void JFW_Base_Defence_Animated_No_VTOL_Secondary::Created(GameObject * obj)
{
	popup = false;
	attack = false;
	primary = true;
	Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,0,false);
	Commands->Enable_Enemy_Seen(obj,true);
}
void JFW_Base_Defence_Animated_No_VTOL_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (!Is_VTOLVehicle(seen))
	{
		if (popup == false)
		{
			popup = true;
			Commands->Start_Timer(obj,this,Get_Float_Parameter("PopupTime"),2);
			Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,Get_Float_Parameter("LastFrame"),false);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("AttackTimer"),1);
		}
		else if (attack == true)
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack_Hold(seen,Get_Float_Parameter("MaxAttackDistance"),0,primary,false);
			Commands->Action_Attack(obj,params);
			if (primary == true)
			{
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Base_Defence_Animated_No_VTOL_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}
void JFW_Base_Defence_Animated_No_VTOL_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		popup = false;
		attack = false;
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,Get_Float_Parameter("LastFrame"),0,false);
		Commands->Action_Reset(obj,100);
	}
	if (number == 2)
	{
		attack = true;
	}
}
void JFW_Base_Defence_Animated_No_VTOL_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&popup);
	Auto_Save_Variable(2,1,&primary);
	Auto_Save_Variable(3,1,&attack);
}
void JFW_Base_Defence_Animated_VTOL_Only_Secondary::Created(GameObject * obj)
{
	popup = false;
	attack = false;
	primary = true;
	Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,0,false);
	Commands->Enable_Enemy_Seen(obj,true);
}
void JFW_Base_Defence_Animated_VTOL_Only_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (Is_VTOLVehicle(seen))
	{
		if (popup == false)
		{
			popup = true;
			Commands->Start_Timer(obj,this,Get_Float_Parameter("PopupTime"),2);
			Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,Get_Float_Parameter("LastFrame"),false);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("AttackTimer"),1);
		}
		else if (attack == true)
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack_Hold(seen,Get_Float_Parameter("MaxAttackDistance"),0,primary,false);
			Commands->Action_Attack(obj,params);
			if (primary == true)
			{	
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Base_Defence_Animated_VTOL_Only_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}
void JFW_Base_Defence_Animated_VTOL_Only_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		popup = false;
		attack = false;
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,Get_Float_Parameter("LastFrame"),0,false);
		Commands->Action_Reset(obj,100);
	}
	if (number == 2)
	{
		attack = true;
	}
}
void JFW_Base_Defence_Animated_VTOL_Only_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&popup);
	Auto_Save_Variable(2,1,&primary);
	Auto_Save_Variable(3,1,&attack);
}
void JFW_Building_Gun_No_VTOL::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Weapon_No_VTOL",params);
	}
}
void JFW_Building_Gun_No_VTOL::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_No_VTOL::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
			else
			{
				Commands->Send_Custom_Event(obj,object,x,1,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_No_VTOL::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Weapon_No_VTOL::Created(GameObject * obj)
{
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
}
void JFW_Building_Gun_Weapon_No_VTOL::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		if (param == false)
		{
			Commands->Enable_Enemy_Seen(obj,false);
		}
		else
		{
			Commands->Enable_Enemy_Seen(obj,true);
		}
	}
}
void JFW_Building_Gun_Weapon_No_VTOL::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	float minrange;
	float maxrange;
	float range;
	if (!Is_VTOLVehicle(seen))
	{
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange))
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(seen,maxrange,0,true);
			Commands->Action_Attack(obj,params);
			Commands->Start_Timer(obj,this,1.0,1);
		}
	}
}
void JFW_Building_Gun_Weapon_No_VTOL::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_Building_Gun_VTOL_Only::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Weapon_VTOL_Only",params);
	}
}
void JFW_Building_Gun_VTOL_Only::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_VTOL_Only::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
			else
			{
				Commands->Send_Custom_Event(obj,object,x,1,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_VTOL_Only::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Weapon_VTOL_Only::Created(GameObject * obj)
{
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
}
void JFW_Building_Gun_Weapon_VTOL_Only::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		if (param == false)
		{
			Commands->Enable_Enemy_Seen(obj,false);
		}
		else
		{
			Commands->Enable_Enemy_Seen(obj,true);
		}
	}
}
void JFW_Building_Gun_Weapon_VTOL_Only::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	float minrange;
	float maxrange;
	float range;
	if (Is_VTOLVehicle(seen))
	{
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange))
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(seen,maxrange,0,true);
			Commands->Action_Attack(obj,params);
			Commands->Start_Timer(obj,this,1.0,1);
		}
	}
}
void JFW_Building_Gun_Weapon_VTOL_Only::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_Repair_Zone_VTOL_Only::Entered(GameObject * obj,GameObject * enter)
{
	int Player_Type = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,Player_Type) != 0)
	{
		return;
	}
	if (Is_VTOLVehicle(enter))
	{
		if (!Commands->Is_A_Star(enter))
		{
			Commands->Start_Timer(obj,this,1.0,Commands->Get_ID(enter));
		}
	}
}
void JFW_Repair_Zone_VTOL_Only::Timer_Expired(GameObject * obj,int number)
{
	Vector3 pos1;
	Vector3 pos2;
	float distance;
	pos1 = Commands->Get_Position(obj);
	pos2 = Commands->Get_Position(Commands->Find_Object(number));
	distance = Commands->Get_Distance(pos1,pos2);
	if (distance <= Get_Float_Parameter("Repair_Distance"))
	{
		float Max_Health = Commands->Get_Max_Health(Commands->Find_Object(number));
		float Health = Commands->Get_Health(Commands->Find_Object(number));
		float Max_Shield_Strength = Commands->Get_Max_Shield_Strength(Commands->Find_Object(number));
		float Shield_Strength = Commands->Get_Shield_Strength(Commands->Find_Object(number));
		if (Health < Max_Health)
		{
			Commands->Set_Health(Commands->Find_Object(number), Health + Get_Float_Parameter("Repair_Health"));
		}
		if (Shield_Strength < Max_Shield_Strength)
		{
			Commands->Set_Shield_Strength(Commands->Find_Object(number), Shield_Strength + Get_Float_Parameter("Repair_Health"));
		}
		Commands->Start_Timer(obj, this, 1.0, number);
	}
}
void JFW_Repair_Zone_No_VTOL::Entered(GameObject * obj,GameObject * enter)
{
	int Player_Type = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,Player_Type) != 0)
	{
		return;
	}
	if (!Is_VTOLVehicle(enter))
	{
		if (!Commands->Is_A_Star(enter))
		{
			Commands->Start_Timer(obj,this,1.0,Commands->Get_ID(enter));
		}
	}
}
void JFW_Repair_Zone_No_VTOL::Timer_Expired(GameObject * obj,int number)
{
	Vector3 pos1;
	Vector3 pos2;
	float distance;
	pos1 = Commands->Get_Position(obj);
	pos2 = Commands->Get_Position(Commands->Find_Object(number));
	distance = Commands->Get_Distance(pos1,pos2);
	if (distance <= Get_Float_Parameter("Repair_Distance"))
	{
		float Max_Health = Commands->Get_Max_Health(Commands->Find_Object(number));
		float Health = Commands->Get_Health(Commands->Find_Object(number));
		float Max_Shield_Strength = Commands->Get_Max_Shield_Strength(Commands->Find_Object(number));
		float Shield_Strength = Commands->Get_Shield_Strength(Commands->Find_Object(number));
		if (Health < Max_Health)
		{
			Commands->Set_Health(Commands->Find_Object(number), Health + Get_Float_Parameter("Repair_Health"));
		}
		if (Shield_Strength < Max_Shield_Strength)
		{
			Commands->Set_Shield_Strength(Commands->Find_Object(number), Shield_Strength + Get_Float_Parameter("Repair_Health"));
		}
		Commands->Start_Timer(obj, this, 1.0, number);
	}
}
void JFW_Building_Gun_No_VTOL_Secondary::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Weapon_No_VTOL_Secondary",params);
	}
}
void JFW_Building_Gun_No_VTOL_Secondary::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_No_VTOL_Secondary::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
			else
			{
				Commands->Send_Custom_Event(obj,object,x,1,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_No_VTOL_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Weapon_No_VTOL_Secondary::Created(GameObject * obj)
{
	int visible;
	primary = true;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
}
void JFW_Building_Gun_Weapon_No_VTOL_Secondary::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		if (param == false)
		{
			Commands->Enable_Enemy_Seen(obj,false);
		}
		else
		{
			Commands->Enable_Enemy_Seen(obj,true);
		}
	}
}
void JFW_Building_Gun_Weapon_No_VTOL_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	float minrange;
	float maxrange;
	float range;
	if (!Is_VTOLVehicle(seen))
	{
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange))
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(seen,maxrange,0,primary);
			Commands->Action_Attack(obj,params);
			Commands->Start_Timer(obj,this,1.0,1);
			if (primary == true)
			{
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Building_Gun_Weapon_No_VTOL_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_Building_Gun_VTOL_Only_Secondary::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Weapon_VTOL_Only_Secondary",params);
	}
}
void JFW_Building_Gun_VTOL_Only_Secondary::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_VTOL_Only_Secondary::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
			else
			{
				Commands->Send_Custom_Event(obj,object,x,1,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_VTOL_Only_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Weapon_VTOL_Only_Secondary::Created(GameObject * obj)
{
	int visible;
	primary = true;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
}
void JFW_Building_Gun_Weapon_VTOL_Only_Secondary::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		if (param == false)
		{
			Commands->Enable_Enemy_Seen(obj,false);
		}
		else
		{
			Commands->Enable_Enemy_Seen(obj,true);
		}
	}
}
void JFW_Building_Gun_Weapon_VTOL_Only_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	float minrange;
	float maxrange;
	float range;
	if (Is_VTOLVehicle(seen))
	{
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange))
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(seen,maxrange,0,primary);
			Commands->Action_Attack(obj,params);
			Commands->Start_Timer(obj,this,1.0,1);
			if (primary == true)
			{
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Building_Gun_Weapon_VTOL_Only_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		Commands->Action_Reset(obj,100);
	}
}
void JFW_Building_Gun_Weapon_No_VTOL_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&primary);
}
void JFW_Building_Gun_Weapon_VTOL_Only_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&primary);
}
void JFW_Building_Gun_Animated_Weapon_No_VTOL::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	enemyseen = true;
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Action_Reset(obj,100);
}
void JFW_Building_Gun_Animated_Weapon_VTOL_Only::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	enemyseen = true;
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Action_Reset(obj,100);
}
void JFW_Building_Gun_Animated_Weapon_No_VTOL_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	enemyseen = true;
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Action_Reset(obj,100);
}
void JFW_Building_Gun_Animated_Weapon_VTOL_Only_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	enemyseen = true;
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Action_Reset(obj,100);
}
void JFW_Building_Gun_Animated_No_VTOL::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("EffectPreset"),Get_Parameter("EffectAnimation"),Get_Parameter("EffectTime"),Get_Parameter("EffectFrame"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Animated_Weapon_No_VTOL",params);
	}
}
void JFW_Building_Gun_Animated_No_VTOL::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_Animated_No_VTOL::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Animated_No_VTOL::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Animated_Weapon_No_VTOL::Created(GameObject * obj)
{
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
	attackid = 0;
	GameObject *effect = Commands->Create_Object(Get_Parameter("EffectPreset"),Commands->Get_Position(obj));
	if (effect != 0)
	{
		effectid = Commands->Get_ID(effect);
		lastframe = false;
		Commands->Set_Animation(effect,Get_Parameter("EffectAnimation"),false,NULL,0,0,false);
	}
}
void JFW_Building_Gun_Animated_Weapon_No_VTOL::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		Commands->Enable_Enemy_Seen(obj,false);
		enemyseen = false;
	}
}
void JFW_Building_Gun_Animated_Weapon_No_VTOL::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (!Is_VTOLVehicle(seen))
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			enemyseen = false;
			Commands->Enable_Enemy_Seen(obj,false);
			attackid = Commands->Get_ID(seen);
			if (lastframe == false)
			{
				lastframe = true;
				Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,0,Get_Float_Parameter("EffectFrame"),false);
				Commands->Start_Timer(obj,this,Get_Float_Parameter("EffectTime"),1);
			}
		}
	}
}
void JFW_Building_Gun_Animated_Weapon_No_VTOL::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(Commands->Find_Object(attackid));
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if (lastframe == true)
		{
			lastframe = false;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,Get_Float_Parameter("EffectFrame"),0,false);
		}
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(Commands->Find_Object(attackid),maxrange,0,true);
			Commands->Action_Attack(obj,params);
		}
	}
}
void JFW_Building_Gun_Animated_VTOL_Only::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("EffectPreset"),Get_Parameter("EffectAnimation"),Get_Parameter("EffectTime"),Get_Parameter("EffectFrame"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Animated_Weapon_VTOL_Only",params);
	}
}
void JFW_Building_Gun_Animated_VTOL_Only::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_Animated_VTOL_Only::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Animated_VTOL_Only::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Animated_Weapon_VTOL_Only::Created(GameObject * obj)
{
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
	enemyseen = true;
	attackid = 0;
	GameObject *effect = Commands->Create_Object(Get_Parameter("EffectPreset"),Commands->Get_Position(obj));
	if (effect != 0)
	{
		effectid = Commands->Get_ID(effect);
		lastframe = false;
		Commands->Set_Animation(effect,Get_Parameter("EffectAnimation"),false,NULL,0,0,false);
	}
}
void JFW_Building_Gun_Animated_Weapon_VTOL_Only::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		Commands->Enable_Enemy_Seen(obj,false);
		enemyseen = false;
	}
}
void JFW_Building_Gun_Animated_Weapon_VTOL_Only::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (Is_VTOLVehicle(seen))
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			enemyseen = false;
			Commands->Enable_Enemy_Seen(obj,false);
			attackid = Commands->Get_ID(seen);
			if (lastframe == false)
			{
				lastframe = true;
				Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,0,Get_Float_Parameter("EffectFrame"),false);
				Commands->Start_Timer(obj,this,Get_Float_Parameter("EffectTime"),1);
			}
		}
	}
}
void JFW_Building_Gun_Animated_Weapon_VTOL_Only::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(Commands->Find_Object(attackid));
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if (lastframe == true)
		{
			lastframe = false;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,Get_Float_Parameter("EffectFrame"),0,false);
		}
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(Commands->Find_Object(attackid),maxrange,0,true);
			Commands->Action_Attack(obj,params);
		}
	}
}
void JFW_Building_Gun_Animated_No_VTOL_Secondary::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("EffectPreset"),Get_Parameter("EffectAnimation"),Get_Parameter("EffectTime"),Get_Parameter("EffectFrame"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Animated_Weapon_No_VTOL_Secondary",params);
	}
}
void JFW_Building_Gun_Animated_No_VTOL_Secondary::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_Animated_No_VTOL_Secondary::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Animated_No_VTOL_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Animated_Weapon_No_VTOL_Secondary::Created(GameObject * obj)
{
	primary = true;
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
	enemyseen = true;
	attackid = 0;
	GameObject *effect = Commands->Create_Object(Get_Parameter("EffectPreset"),Commands->Get_Position(obj));
	if (effect != 0)
	{
		effectid = Commands->Get_ID(effect);
		lastframe = false;
		Commands->Set_Animation(effect,Get_Parameter("EffectAnimation"),false,NULL,0,0,false);
	}
}
void JFW_Building_Gun_Animated_Weapon_No_VTOL_Secondary::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		Commands->Enable_Enemy_Seen(obj,false);
		enemyseen = false;
	}
}
void JFW_Building_Gun_Animated_Weapon_No_VTOL_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (!Is_VTOLVehicle(seen))
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			enemyseen = false;
			Commands->Enable_Enemy_Seen(obj,false);
			attackid = Commands->Get_ID(seen);
			if (lastframe == false)
			{
				lastframe = true;
				Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,0,Get_Float_Parameter("EffectFrame"),false);
				Commands->Start_Timer(obj,this,Get_Float_Parameter("EffectTime"),1);
			}
		}
	}
}
void JFW_Building_Gun_Animated_Weapon_No_VTOL_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(Commands->Find_Object(attackid));
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if (lastframe == true)
		{
			lastframe = false;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,Get_Float_Parameter("EffectFrame"),0,false);
		}
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(Commands->Find_Object(attackid),maxrange,0,primary);
			Commands->Action_Attack(obj,params);
			if (primary == true)
			{
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Building_Gun_Animated_VTOL_Only_Secondary::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("EffectPreset"),Get_Parameter("EffectAnimation"),Get_Parameter("EffectTime"),Get_Parameter("EffectFrame"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Animated_Weapon_VTOL_Only_Secondary",params);
	}
}
void JFW_Building_Gun_Animated_VTOL_Only_Secondary::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_Animated_VTOL_Only_Secondary::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Animated_VTOL_Only_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Animated_Weapon_VTOL_Only_Secondary::Created(GameObject * obj)
{
	primary = true;
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
	enemyseen = true;
	attackid = 0;
	GameObject *effect = Commands->Create_Object(Get_Parameter("EffectPreset"),Commands->Get_Position(obj));
	if (effect != 0)
	{
		effectid = Commands->Get_ID(effect);
		lastframe = false;
		Commands->Set_Animation(effect,Get_Parameter("EffectAnimation"),false,NULL,0,0,false);
	}
}
void JFW_Building_Gun_Animated_Weapon_VTOL_Only_Secondary::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		Commands->Enable_Enemy_Seen(obj,false);
		enemyseen = false;
	}
}
void JFW_Building_Gun_Animated_Weapon_VTOL_Only_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (!Is_VTOLVehicle(seen))
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			enemyseen = false;
			Commands->Enable_Enemy_Seen(obj,false);
			attackid = Commands->Get_ID(seen);
			if (lastframe == false)
			{
				lastframe = true;
				Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,0,Get_Float_Parameter("EffectFrame"),false);
				Commands->Start_Timer(obj,this,Get_Float_Parameter("EffectTime"),1);
			}
		}
	}
}
void JFW_Building_Gun_Animated_Weapon_VTOL_Only_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(Commands->Find_Object(attackid));
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if (lastframe == true)
		{
			lastframe = false;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,Get_Float_Parameter("EffectFrame"),0,false);
		}
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(Commands->Find_Object(attackid),maxrange,0,primary);
			Commands->Action_Attack(obj,params);
			if (primary == true)
			{
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Building_Gun_Animated_Weapon_No_VTOL::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&effectid);
	Auto_Save_Variable(2,4,&attackid);
	Auto_Save_Variable(3,1,&enemyseen);
	Auto_Save_Variable(4,1,&lastframe);
}
void JFW_Building_Gun_Animated_Weapon_VTOL_Only::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&effectid);
	Auto_Save_Variable(2,4,&attackid);
	Auto_Save_Variable(3,1,&enemyseen);
	Auto_Save_Variable(4,1,&lastframe);
}
void JFW_Building_Gun_Animated_Weapon_No_VTOL_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&primary);
	Auto_Save_Variable(2,4,&effectid);
	Auto_Save_Variable(3,4,&attackid);
	Auto_Save_Variable(4,1,&enemyseen);
	Auto_Save_Variable(5,1,&lastframe);
}
void JFW_Building_Gun_Animated_Weapon_VTOL_Only_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&primary);
	Auto_Save_Variable(2,4,&effectid);
	Auto_Save_Variable(3,4,&attackid);
	Auto_Save_Variable(4,1,&enemyseen);
	Auto_Save_Variable(5,1,&lastframe);
}
void JFW_Refill_Buy::Entered(GameObject * obj,GameObject * enter)
{
	int x;
	int cost;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,x) != 0)
	{
		return;
	}
	cost = Get_Int_Parameter("Cost");
	if (cost <= Commands->Get_Money(enter))
	{
		cost = -cost;
		Commands->Give_Money(enter,(float)cost,0);
		Grant_Refill(enter);
	}
}
void JFW_Powerup_Buy::Entered(GameObject * obj,GameObject * enter)
{
	const char *preset;
	int x;
	int cost;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,x) != 0)
	{
		return;
	}
	preset = Get_Parameter("Preset_Name");
	cost = Get_Int_Parameter("Cost");
	if (cost <= Commands->Get_Money(enter))
	{
		cost = -cost;
		Commands->Give_Money(enter,(float)cost,0);
		Grant_Powerup(enter,preset);
	}
}
void JFW_Vehicle_Buy::Entered(GameObject * obj,GameObject * enter)
{
	const char *preset;
	int x;
	int cost;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,x) != 0)
	{
		return;
	}
	preset = Get_Parameter("Preset_Name");
	cost = Get_Int_Parameter("Cost");
	if (cost <= Commands->Get_Money(enter))
	{
		cost = -cost;
		Commands->Give_Money(enter,(float)cost,0);
		Create_Vehicle(preset,5.0,enter,x);
	}
}
void JFW_Refill_Powerup::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == CUSTOM_EVENT_POWERUP)
	{
		Grant_Refill(sender);
	}
}
void JFW_Timer_Custom_On_Off::Created(GameObject * obj)
{
	enabled = false;
}
void JFW_Timer_Custom_On_Off::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("EnableMessage"))
	{
		enabled = true;
		float timertime;
		int timernumber;
		timertime = Get_Float_Parameter("Time");
		timernumber = Get_Int_Parameter("TimerNum");
		Commands->Start_Timer(obj,this,timertime,timernumber);
	}
	if (message == Get_Int_Parameter("DisableMessage"))
	{
		enabled = false;
	}
}
void JFW_Timer_Custom_On_Off::Timer_Expired(GameObject * obj,int number)
{
	int timernumber;
	int repeat;
	float timertime;
	GameObject * object;
	int ID,msg,param;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	repeat = Get_Int_Parameter("Repeat");
	ID = Get_Int_Parameter("ID");
	msg = Get_Int_Parameter("Message");
	param = Get_Int_Parameter("Param");
	object = Commands->Find_Object(ID);
	if (number == timernumber)
	{
		Commands->Send_Custom_Event(obj,object,msg,param,0);
		if ((repeat == 1) && (enabled == true))
		{
			Commands->Start_Timer(obj,this,timertime,timernumber);
		}
	}
}
void JFW_Timer_Custom_On_Off::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
}
void JFW_Zone_Weapon::Entered(GameObject * obj,GameObject * enter)
{
	const char *preset;
	int x;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,x) != 0)
	{
		return;
	}
	preset = Get_Parameter("Weapon_Name");
	Commands->Give_Powerup(enter, preset, true);
}
void JFW_Zone_Vehicle::Entered(GameObject * obj,GameObject * enter)
{
	const char *preset;
	int x;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,x) != 0)
	{
		return;
	}
	preset = Get_Parameter("Preset_Name");
	Create_Vehicle(preset,5.0,enter,x);
}
void JFW_Zone_Powerup::Entered(GameObject * obj,GameObject * enter)
{
	const char *preset;
	int x;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,x) != 0)
	{
		return;
	}
	preset = Get_Parameter("Preset_Name");
	Grant_Powerup(enter,preset);
}
void JFW_Zone_Refill::Entered(GameObject * obj,GameObject * enter)
{
	int x;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,x) != 0)
	{
		return;
	}
	Grant_Refill(enter);
}
void JFW_Timer_Play_Random_Cinematic::Created(GameObject * obj)
{
	float timertime;
	int timernumber;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
}
void JFW_Timer_Play_Random_Cinematic::Timer_Expired(GameObject * obj,int number)
{
	int timernumber;
	int repeat;
	float timertime;
	const char *scriptname;
	char sn[20];
	int random = Commands->Get_Random_Int(1,5);
	Vector3 position;
	GameObject * object;
	float facing;
	sprintf(sn,"Script_Name%d",random);
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	repeat = Get_Int_Parameter("Repeat");
	scriptname = Get_Parameter(sn);
	position = Get_Vector3_Parameter("location");
	facing = Get_Float_Parameter("Facing");
	if (number == timernumber)
	{
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		if (repeat == 1)
		{	
			Commands->Start_Timer(obj,this,timertime,timernumber);
		}
	}
}
void JFW_Random_Timer_Play_Random_Cinematic::Created(GameObject * obj)
{
	float timertimemin;
	float timertimemax;
	float timertime;
	int timernumber;
	timertimemin = Get_Float_Parameter("TimeMin");
	timertimemax = Get_Float_Parameter("TimeMax");
	timertime = Commands->Get_Random(timertimemin,timertimemax);
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
}
void JFW_Random_Timer_Play_Random_Cinematic::Timer_Expired(GameObject * obj,int number)
{
	int timernumber;
	int repeat;
	float timertimemin;
	float timertimemax;
	float timertime;
	const char *scriptname;
	char sn[20];
	int random = Commands->Get_Random_Int(1,5);
	Vector3 position;
	GameObject * object;
	float facing;
	sprintf(sn,"Script_Name%d",random);
	timertimemin = Get_Float_Parameter("TimeMin");
	timertimemax = Get_Float_Parameter("TimeMax");
	timertime = Commands->Get_Random(timertimemin,timertimemax);
	timernumber = Get_Int_Parameter("TimerNum");
	repeat = Get_Int_Parameter("Repeat");
	scriptname = Get_Parameter(sn);
	position = Get_Vector3_Parameter("location");
	facing = Get_Float_Parameter("Facing");
	if (number == timernumber)
	{
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		if (repeat == 1)
		{	
			Commands->Start_Timer(obj,this,timertime,timernumber);
		}
	}
}
void JFW_Vehicle_Powerup::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	GameObject *o = Get_Vehicle(sender);
	if (o != 0)
	{
		Commands->Send_Custom_Event(obj,o,Get_Int_Parameter("Message"),0,0);
	}
}
void JFW_Vehicle_Powerup_Preset::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	GameObject *o = Get_Vehicle(sender);
	if ((o != 0) && (stricmp(Commands->Get_Preset_Name(o),Get_Parameter("Preset")) == 0))
	{
		Commands->Send_Custom_Event(obj,o,Get_Int_Parameter("Message"),0,0);
	}
}
void JFW_Create_Vehicle_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	Create_Vehicle(Get_Parameter("Preset_Name"),Get_Float_Parameter("Delay"),0,Get_Int_Parameter("Player_Type"));
}
void JFW_Powerup_Send_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == CUSTOM_EVENT_POWERUP)
	{
		Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("ID")),Get_Int_Parameter("Message"),0,0);
	}
}
void JFW_Powerup_Send_Custom_Team::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == CUSTOM_EVENT_POWERUP)
	{
		if (Get_Object_Type(obj) == 0)
		{
			Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("NodID")),Get_Int_Parameter("NodMessage"),0,0);
		}
		else
		{
			Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("GDIID")),Get_Int_Parameter("GDIMessage"),0,0);
		}
	}
}
void JFW_Zone_Send_Custom_Team::Entered(GameObject * obj,GameObject * enter)
{
	if (Get_Object_Type(enter) == 0)
	{
		GameObject * object = Commands->Find_Object(Get_Int_Parameter("NodID"));
		int message;
		int param;
		message = Get_Int_Parameter("NodEnterMessage");
		param = Get_Int_Parameter("NodEnterParam");
		if (message != 0)
		{
			if (param == 0)
			{
				param = Commands->Get_ID(enter);
			}
			Commands->Send_Custom_Event(obj,object,message,param,0);
		}
	}
	else
	{
		GameObject * object = Commands->Find_Object(Get_Int_Parameter("GDIID"));
		int message;
		int param;
		message = Get_Int_Parameter("GDIEnterMessage");
		param = Get_Int_Parameter("GDIEnterParam");
		if (message != 0)
		{
			if (param == 0)
			{
				param = Commands->Get_ID(enter);
			}
			Commands->Send_Custom_Event(obj, object,message,param,0);
		}
	}
}

void JFW_Zone_Send_Custom_Team::Exited(GameObject * obj, GameObject * exit)
{
	if (Get_Object_Type(exit) == 0)
	{
		GameObject * object = Commands->Find_Object(Get_Int_Parameter("NodID"));
		int message;
		int param;
		message = Get_Int_Parameter("NodExitMessage");
		param = Get_Int_Parameter("NodExitParam");
		if (message != 0)
		{
			if (param == 0)
			{
				param = Commands->Get_ID(exit);
			}
			Commands->Send_Custom_Event(obj,object,message,param,0);
		}
	}
	else
	{
		GameObject * object = Commands->Find_Object(Get_Int_Parameter("GDIID"));
		int message;
		int param;
		message = Get_Int_Parameter("GDIExitMessage");
		param = Get_Int_Parameter("GDIExitParam");
		if (message != 0)
		{
			if (param == 0)
			{
				param = Commands->Get_ID(exit);
			}
			Commands->Send_Custom_Event(obj, object,message,param,0);
		}
	}
}
void JFW_Regenerate_Health_Conditional::Created(GameObject * obj)
{
	enabled = false;
}
void JFW_Regenerate_Health_Conditional::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("EnableMessage"))
	{
		enabled = true;
		Commands->Send_Custom_Event(obj,obj,100000000,0,0);
		return;
	}
	if (message == Get_Int_Parameter("DisableMessage"))
	{
		enabled = false;
		return;
	}
	if ((message == 100000000) && (enabled == true))
	{
		float health = Commands->Get_Health(obj);
		Commands->Set_Health(obj,health+Get_Int_Parameter("Amount"));
		health = Commands->Get_Shield_Strength(obj);
		Commands->Set_Shield_Strength(obj,health+Get_Int_Parameter("Amount"));
		return;
	}
}
void JFW_Regenerate_Health_Conditional::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
}
void JFW_Drone_Damage::Created(GameObject * obj)
{
	enabled = false;
}
void JFW_Drone_Damage::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if ((message == 0) && (enabled == true))
	{
		float health = Commands->Get_Health(obj);
		Commands->Set_Health(obj,health-Get_Int_Parameter("Amount"));
		health = Commands->Get_Shield_Strength(obj);
		Commands->Set_Shield_Strength(obj,health-Get_Int_Parameter("Amount"));
		Commands->Send_Custom_Event(obj,obj,0,0,1.0);
	}
}
void JFW_Drone_Damage::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
}
void JFW_Drone_Damage::Damaged(GameObject * obj,GameObject * damager,float damage)
{
	GameObject *o = Get_Vehicle(damager);
	if (o != 0)
	{
		damager = o;
	}
	if ((damage < 0) && (Get_Int_Parameter("RepairStop") == 1))
	{
		enabled = false;
	}
	if (stricmp(Get_Parameter("Preset"),Commands->Get_Preset_Name(damager)) == 0)
	{
		enabled = true;
		Commands->Send_Custom_Event(obj,damager,Get_Int_Parameter("Custom"),0,0);
		Commands->Send_Custom_Event(obj,obj,0,0,0);
	}
}
void JFW_Vechicle_Animation_2::Timer_Expired(GameObject * obj,int number)
{
	Vector3 position = Commands->Get_Position(obj);
	if ((xpos == 0) && (ypos == 0) && (zpos == 0))
	{
		xpos = position.X;
		ypos = position.Y;
		zpos = position.Z;
	}
	if ((position.X != xpos) || (position.Y != ypos) || (position.Z != zpos))
	{
		xpos = position.X;
		ypos = position.Y;
		zpos = position.Z;
		if (enabled == false)
		{
			enabled = true;
			const char *subobject = Get_Parameter("UpSubobject");
			if(stricmp(subobject,"0") == 0)
			{
				subobject = 0;
			}
			float firstframe = Get_Float_Parameter("UpFirstFrame");
			if (firstframe == -1)
			{
				firstframe = Get_Animation_Frame(obj);
			}
			Commands->Set_Animation(obj,Get_Parameter("UpAnimation"),false,subobject,firstframe,Get_Float_Parameter("UpLastFrame"),Get_Int_Parameter("UpBlended"));
		}
	}
	else 
	{
		const char *subobject = Get_Parameter("DownSubobject");
		if(stricmp(subobject,"0") == 0)
		{
			subobject = 0;
		}
		float firstframe = Get_Float_Parameter("DownFirstFrame");
		if (firstframe == -1)
		{
			firstframe = Get_Animation_Frame(obj);
		}
		Commands->Set_Animation(obj,Get_Parameter("DownAnimation"),false,subobject,firstframe,Get_Float_Parameter("DownLastFrame"),Get_Int_Parameter("DownBlended"));
		enabled = false;
	}
	Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNum"));
}
void JFW_Vechicle_Animation_2::Created(GameObject * obj)
{
	xpos = 0;
	ypos = 0;
	zpos = 0;
	enabled = false;
	Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNum"));
}
void JFW_Vechicle_Animation_2::Animation_Complete(GameObject * obj,const char *anim)
{
	if (stricmp(anim,Get_Parameter("UpAnimation")) == 0)
	{
		const char *subobject = Get_Parameter("Subobject");
		if(stricmp(subobject,"0") == 0)
		{
			subobject = 0;
		}
		float firstframe = Get_Float_Parameter("FirstFrame");
		if (firstframe == -1)
		{
			firstframe = Get_Animation_Frame(obj);
		}
		Commands->Set_Animation(obj,Get_Parameter("Animation"),true,subobject,firstframe,Get_Float_Parameter("LastFrame"),Get_Int_Parameter("Blended"));
	}
}
void JFW_Vechicle_Animation_2::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
	Auto_Save_Variable(2,4,&xpos);
	Auto_Save_Variable(3,4,&ypos);
	Auto_Save_Variable(4,4,&zpos);
}
void JFW_Zone_Animation::Created(GameObject * obj)
{
	enabled = false;
	GameObject *object = Commands->Create_Object("Generic_Cinematic",Commands->Get_Position(obj));
	Commands->Set_Model(object,Get_Parameter("Model"));
	ID = Commands->Get_ID(object);
}
void JFW_Zone_Animation::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
	Auto_Save_Variable(1,2,&ID);
}
void JFW_Zone_Animation::Entered(GameObject * obj,GameObject * enter)
{
	enabled = true;
	const char *subobject = Get_Parameter("UpSubobject");
	if(stricmp(subobject,"0") == 0)
	{
		subobject = 0;
	}
	float firstframe = Get_Float_Parameter("UpFirstFrame");
	if (firstframe == -1)
	{
		firstframe = Get_Animation_Frame(Commands->Find_Object(ID));
	}
	Commands->Set_Animation(Commands->Find_Object(ID),Get_Parameter("UpAnimation"),false,subobject,firstframe,Get_Float_Parameter("UpLastFrame"),Get_Int_Parameter("UpBlended"));
}
void JFW_Zone_Animation::Animation_Complete(GameObject * obj,const char *anim)
{
	if (stricmp(anim,Get_Parameter("UpAnimation")) == 0)
	{
		const char *subobject = Get_Parameter("Subobject");
		if(stricmp(subobject,"0") == 0)
		{
			subobject = 0;
		}
		float firstframe = Get_Float_Parameter("FirstFrame");
		if (firstframe == -1)
		{
			firstframe = Get_Animation_Frame(Commands->Find_Object(ID));
		}
		Commands->Set_Animation(Commands->Find_Object(ID),Get_Parameter("Animation"),true,subobject,firstframe,Get_Float_Parameter("LastFrame"),Get_Int_Parameter("Blended"));
	}
}
void JFW_Zone_Animation::Exited(GameObject * obj, GameObject * exit)
{
	const char *subobject = Get_Parameter("DownSubobject");
	if(stricmp(subobject,"0") == 0)
	{
		subobject = 0;
	}
	float firstframe = Get_Float_Parameter("DownFirstFrame");
	if (firstframe == -1)
	{
		firstframe = Get_Animation_Frame(Commands->Find_Object(ID));
	}
	Commands->Set_Animation(Commands->Find_Object(ID),Get_Parameter("DownAnimation"),false,subobject,firstframe,Get_Float_Parameter("DownLastFrame"),Get_Int_Parameter("DownBlended"));
	enabled = false;
}
void JFW_Group_Purchase_Zone::Created(GameObject * obj)
{
	cash = 0;
	enabled = true;
}
void JFW_Group_Purchase_Zone::Entered(GameObject * obj,GameObject * enter)
{
	if (enabled == true)
	{
		float money = Commands->Get_Money(enter);
		if (money >= Get_Float_Parameter("CashPerPerson"))
		{
			Commands->Give_Money(enter,Get_Float_Parameter("CashPerPerson"),0);
			cash += Get_Float_Parameter("CashPerPerson");
		}
		if (cash >= Get_Float_Parameter("TotalCash"))
		{
			cash = 0;
			enabled = false;
			Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("ID")),Get_Int_Parameter("Message"),0,0);
		}
	}
}
void JFW_Group_Purchase_Zone::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&cash);
	Auto_Save_Variable(2,1,&enabled);
}
void JFW_Zone_Timer::Created(GameObject * obj)
{
	count = 0;
	enabled = true;
}
void JFW_Zone_Timer::Entered(GameObject * obj,GameObject * enter)
{
	count++;
	if (enabled == true)
	{
		if (count == 1)
		{
			Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNum"));
		}
	}
}
void JFW_Zone_Timer::Exited(GameObject * obj, GameObject * exit)
{
	count--;
}
void JFW_Zone_Timer::Timer_Expired(GameObject * obj,int number)
{
	if (count >= Get_Int_Parameter("Count"))
	{
		enabled = false;
		Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("ID")),Get_Int_Parameter("Message"),0,0);
	}
}
void JFW_Zone_Timer::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&count);
	Auto_Save_Variable(2,1,&enabled);
}
void JFW_Building_Damage::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Ranged_Damage_To_Buildings_Team(Get_Int_Parameter("Player_Type"),Get_Float_Parameter("Damage"),Get_Parameter("Warhead"),Commands->Get_Position(sender),Get_Float_Parameter("Distance"),Commands->Find_Object(param));
	}
}
void JFW_Building_Damage_Scale::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Ranged_Scale_Damage_To_Buildings_Team(Get_Int_Parameter("Player_Type"),Get_Float_Parameter("Damage"),Get_Parameter("Warhead"),Commands->Get_Position(sender),Get_Float_Parameter("Distance"),Commands->Find_Object(param));
	}
}
void JFW_Weapon_Change_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Commands->Clear_Weapons(obj);
		Commands->Give_Powerup(obj,Get_Parameter("Powerup"),1);
		Commands->Select_Weapon(obj,Get_Parameter("Weapon"));
	}
}
void JFW_Weapon_Change_On_Custom_Sender::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Commands->Clear_Weapons(sender);
		Commands->Give_Powerup(sender,Get_Parameter("Powerup"),1);
		Commands->Select_Weapon(sender,Get_Parameter("Weapon"));
	}
}
void JFW_Set_Model_On_Custom_Sender::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Commands->Set_Model(sender,Get_Parameter("Model"));
	}
}
void JFW_Send_Driver_Custom_On_Enter::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		Commands->Send_Custom_Event(obj,sender,Get_Int_Parameter("EnterMessage"),0,0);
	}
	if (message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		Commands->Send_Custom_Event(obj,sender,Get_Int_Parameter("ExitMessage"),0,0);
	}
}
void JFW_Weapon_Change_On_Custom_Multiple::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Commands->Clear_Weapons(obj);
		const char *powerup;
		powerup = Get_Parameter("Powerup1");
		if(stricmp(powerup,"0") == 0)
		{
			powerup = 0;
		}
		Commands->Give_Powerup(obj,powerup,1);
		powerup = Get_Parameter("Powerup2");
		if(stricmp(powerup,"0") == 0)
		{
			powerup = 0;
		}
		Commands->Give_Powerup(obj,powerup,1);
		powerup = Get_Parameter("Powerup3");
		if(stricmp(powerup,"0") == 0)
		{
			powerup = 0;
		}
		Commands->Give_Powerup(obj,powerup,1);
		powerup = Get_Parameter("Powerup4");
		if(stricmp(powerup,"0") == 0)
		{
			powerup = 0;
		}
		Commands->Give_Powerup(obj,powerup,1);
		powerup = Get_Parameter("Powerup5");
		if(stricmp(powerup,"0") == 0)
		{
			powerup = 0;
		}
		Commands->Give_Powerup(obj,powerup,1);
		Commands->Select_Weapon(obj,Get_Parameter("Weapon"));
	}
}
void JFW_Weapon_Change_On_Custom_Multiple_Sender::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Commands->Clear_Weapons(sender);
		const char *powerup;
		powerup = Get_Parameter("Powerup1");
		if(stricmp(powerup,"0") == 0)
		{
			powerup = 0;
		}
		Commands->Give_Powerup(sender,powerup,1);
		powerup = Get_Parameter("Powerup2");
		if(stricmp(powerup,"0") == 0)
		{
			powerup = 0;
		}
		Commands->Give_Powerup(sender,powerup,1);
		powerup = Get_Parameter("Powerup3");
		if(stricmp(powerup,"0") == 0)
		{
			powerup = 0;
		}
		Commands->Give_Powerup(sender,powerup,1);
		powerup = Get_Parameter("Powerup4");
		if(stricmp(powerup,"0") == 0)
		{
			powerup = 0;
		}
		Commands->Give_Powerup(sender,powerup,1);
		powerup = Get_Parameter("Powerup5");
		if(stricmp(powerup,"0") == 0)
		{
			powerup = 0;
		}
		Commands->Give_Powerup(sender,powerup,1);
		Commands->Select_Weapon(sender,Get_Parameter("Weapon"));
	}
}
void JFW_Clear_Weapons_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Commands->Clear_Weapons(obj);
	}
}
void JFW_Base_Defence_Animated_Sound::Created(GameObject * obj)
{
	popup = false;
	attack = false;
	Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,0,false);
	Commands->Enable_Enemy_Seen(obj,true);
}
void JFW_Base_Defence_Animated_Sound::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (popup == false)
	{
		popup = true;
		Commands->Start_Timer(obj,this,Get_Float_Parameter("PopupTime"),2);
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,Get_Float_Parameter("LastFrame"),false);
		Commands->Create_Sound(Get_Parameter("Sound"),Commands->Get_Position(seen),obj);
		Commands->Start_Timer(obj,this,Get_Float_Parameter("AttackTimer"),1);
	}
	else if (attack == true)
	{
		ActionParamsStruct params;
		params.Set_Basic(this,100,1,-1);
		params.Set_Attack_Hold(seen,Get_Float_Parameter("MaxAttackDistance"),0,true,false);
		Commands->Action_Attack(obj,params);
	}
}
void JFW_Base_Defence_Animated_Sound::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}
void JFW_Base_Defence_Animated_Sound::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		popup = false;
		attack = false;
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,Get_Float_Parameter("LastFrame"),0,false);
		Commands->Action_Reset(obj,100);
	}
	if (number == 2)
	{
		attack = true;
	}
}
void JFW_Base_Defence_Animated_Sound::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&popup);
	Auto_Save_Variable(2,1,&attack);
}
void JFW_Base_Defence_Animated_Sound_No_Aircraft::Created(GameObject * obj)
{
	popup = false;
	attack = false;
	Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,0,false);
	Commands->Enable_Enemy_Seen(obj,true);
}
void JFW_Base_Defence_Animated_Sound_No_Aircraft::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) != 0))
	{
		if (popup == false)
		{
			popup = true;
			Commands->Start_Timer(obj,this,Get_Float_Parameter("PopupTime"),2);
			Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,Get_Float_Parameter("LastFrame"),false);
			Commands->Create_Sound(Get_Parameter("Sound"),Commands->Get_Position(seen),obj);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("AttackTimer"),1);
		}
		else if (attack == true)
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack_Hold(seen,Get_Float_Parameter("MaxAttackDistance"),0,true,false);
			Commands->Action_Attack(obj,params);
		}
	}
}
void JFW_Base_Defence_Animated_Sound_No_Aircraft::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}
void JFW_Base_Defence_Animated_Sound_No_Aircraft::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		popup = false;
		attack = false;
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,Get_Float_Parameter("LastFrame"),0,false);
		Commands->Action_Reset(obj,100);
	}
	if (number == 2)
	{
		attack = true;
	}
}
void JFW_Base_Defence_Animated_Sound_No_Aircraft::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&popup);
	Auto_Save_Variable(2,1,&attack);
}
void JFW_Base_Defence_Animated_Sound_Aircraft_Only::Created(GameObject * obj)
{
	popup = false;
	attack = false;
	Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,0,false);
	Commands->Enable_Enemy_Seen(obj,true);
}
void JFW_Base_Defence_Animated_Sound_Aircraft_Only::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) == 0))
	{
		if (popup == false)
		{
			popup = true;
			Commands->Start_Timer(obj,this,Get_Float_Parameter("PopupTime"),2);
			Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,Get_Float_Parameter("LastFrame"),false);
			Commands->Create_Sound(Get_Parameter("Sound"),Commands->Get_Position(seen),obj);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("AttackTimer"),1);
		}
		else if (attack == true)
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack_Hold(seen,Get_Float_Parameter("MaxAttackDistance"),0,true,false);
			Commands->Action_Attack(obj,params);
		}
	}
}
void JFW_Base_Defence_Animated_Sound_Aircraft_Only::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}
void JFW_Base_Defence_Animated_Sound_Aircraft_Only::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		popup = false;
		attack = false;
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,Get_Float_Parameter("LastFrame"),0,false);
		Commands->Action_Reset(obj,100);
	}
	if (number == 2)
	{
		attack = true;
	}
}
void JFW_Base_Defence_Animated_Sound_Aircraft_Only::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&popup);
	Auto_Save_Variable(2,1,&attack);
}
void JFW_Base_Defence_Animated_Sound_Secondary::Created(GameObject * obj)
{
	popup = false;
	attack = false;
	primary = true;
	Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,0,false);
	Commands->Enable_Enemy_Seen(obj,true);
}
void JFW_Base_Defence_Animated_Sound_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (popup == false)
	{
		popup = true;
		Commands->Start_Timer(obj,this,Get_Float_Parameter("PopupTime"),2);
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,Get_Float_Parameter("LastFrame"),false);
		Commands->Create_Sound(Get_Parameter("Sound"),Commands->Get_Position(seen),obj);
		Commands->Start_Timer(obj,this,Get_Float_Parameter("AttackTimer"),1);
	}
	else if (attack == true)
	{
		ActionParamsStruct params;
		params.Set_Basic(this,100,1,-1);
		params.Set_Attack_Hold(seen,Get_Float_Parameter("MaxAttackDistance"),0,primary,false);
		Commands->Action_Attack(obj,params);
		if (primary == true)
		{
			primary = false;
		}
		else
		{
			primary = true;
		}
	}
}
void JFW_Base_Defence_Animated_Sound_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}
void JFW_Base_Defence_Animated_Sound_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		popup = false;
		attack = false;
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,Get_Float_Parameter("LastFrame"),0,false);
		Commands->Action_Reset(obj,100);
	}
	if (number == 2)
	{
		attack = true;
	}
}
void JFW_Base_Defence_Animated_Sound_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&popup);
	Auto_Save_Variable(2,1,&primary);
	Auto_Save_Variable(3,1,&attack);
}
void JFW_Base_Defence_Animated_Sound_No_Aircraft_Secondary::Created(GameObject * obj)
{
	popup = false;
	attack = false;
	primary = true;
	Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,0,false);
	Commands->Enable_Enemy_Seen(obj,true);
}
void JFW_Base_Defence_Animated_Sound_No_Aircraft_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) != 0))
	{
		if (popup == false)
		{
			popup = true;
			Commands->Start_Timer(obj,this,Get_Float_Parameter("PopupTime"),2);
			Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,Get_Float_Parameter("LastFrame"),false);
			Commands->Create_Sound(Get_Parameter("Sound"),Commands->Get_Position(seen),obj);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("AttackTimer"),1);
		}
		else if (attack == true)
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack_Hold(seen,Get_Float_Parameter("MaxAttackDistance"),0,primary,false);
			Commands->Action_Attack(obj,params);
			if (primary == true)
			{
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Base_Defence_Animated_Sound_No_Aircraft_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}
void JFW_Base_Defence_Animated_Sound_No_Aircraft_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		popup = false;
		attack = false;
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,Get_Float_Parameter("LastFrame"),0,false);
		Commands->Action_Reset(obj,100);
	}
	if (number == 2)
	{
		attack = true;
	}
}
void JFW_Base_Defence_Animated_Sound_No_Aircraft_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&popup);
	Auto_Save_Variable(2,1,&primary);
	Auto_Save_Variable(3,1,&attack);
}
void JFW_Base_Defence_Animated_Sound_Aircraft_Only_Secondary::Created(GameObject * obj)
{
	popup = false;
	attack = false;
	primary = true;
	Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,0,false);
	Commands->Enable_Enemy_Seen(obj,true);
}
void JFW_Base_Defence_Animated_Sound_Aircraft_Only_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) == 0))
	{
		if (popup == false)
		{
			popup = true;
			Commands->Start_Timer(obj,this,Get_Float_Parameter("PopupTime"),2);
			Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,Get_Float_Parameter("LastFrame"),false);
			Commands->Create_Sound(Get_Parameter("Sound"),Commands->Get_Position(seen),obj);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("AttackTimer"),1);
		}
		else if (attack == true)
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack_Hold(seen,Get_Float_Parameter("MaxAttackDistance"),0,primary,false);
			Commands->Action_Attack(obj,params);
			if (primary == true)
			{	
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Base_Defence_Animated_Sound_Aircraft_Only_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}
void JFW_Base_Defence_Animated_Sound_Aircraft_Only_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		popup = false;
		attack = false;
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,Get_Float_Parameter("LastFrame"),0,false);
		Commands->Action_Reset(obj,100);
	}
	if (number == 2)
	{
		attack = true;
	}
}
void JFW_Base_Defence_Animated_Sound_Aircraft_Only_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&popup);
	Auto_Save_Variable(2,1,&primary);
	Auto_Save_Variable(3,1,&attack);
}
void JFW_Base_Defence_Animated_Sound_No_VTOL::Created(GameObject * obj)
{
	popup = false;
	attack = false;
	Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,0,false);
	Commands->Enable_Enemy_Seen(obj,true);
}
void JFW_Base_Defence_Animated_Sound_No_VTOL::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (!Is_VTOLVehicle(seen))
	{
		if (popup == false)
		{
			popup = true;
			Commands->Start_Timer(obj,this,Get_Float_Parameter("PopupTime"),2);
			Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,Get_Float_Parameter("LastFrame"),false);
			Commands->Create_Sound(Get_Parameter("Sound"),Commands->Get_Position(seen),obj);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("AttackTimer"),1);
		}
		else if (attack == true)
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack_Hold(seen,Get_Float_Parameter("MaxAttackDistance"),0,true,false);
			Commands->Action_Attack(obj,params);
		}
	}
}
void JFW_Base_Defence_Animated_Sound_No_VTOL::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}
void JFW_Base_Defence_Animated_Sound_No_VTOL::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		popup = false;
		attack = false;
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,Get_Float_Parameter("LastFrame"),0,false);
		Commands->Action_Reset(obj,100);
	}
	if (number == 2)
	{
		attack = true;
	}
}
void JFW_Base_Defence_Animated_Sound_No_VTOL::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&popup);
	Auto_Save_Variable(2,1,&attack);
}
void JFW_Base_Defence_Animated_Sound_VTOL_Only::Created(GameObject * obj)
{
	popup = false;
	attack = false;
	Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,0,false);
	Commands->Enable_Enemy_Seen(obj,true);
}
void JFW_Base_Defence_Animated_Sound_VTOL_Only::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (Is_VTOLVehicle(seen))
	{
		if (popup == false)
		{
			popup = true;
			Commands->Start_Timer(obj,this,Get_Float_Parameter("PopupTime"),2);
			Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,Get_Float_Parameter("LastFrame"),false);
			Commands->Create_Sound(Get_Parameter("Sound"),Commands->Get_Position(seen),obj);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("AttackTimer"),1);
		}
		else if (attack == true)
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack_Hold(seen,Get_Float_Parameter("MaxAttackDistance"),0,true,false);
			Commands->Action_Attack(obj,params);
		}
	}
}
void JFW_Base_Defence_Animated_Sound_VTOL_Only::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}
void JFW_Base_Defence_Animated_Sound_VTOL_Only::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		popup = false;
		attack = false;
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,Get_Float_Parameter("LastFrame"),0,false);
		Commands->Action_Reset(obj,100);
	}
	if (number == 2)
	{
		attack = true;
	}
}
void JFW_Base_Defence_Animated_Sound_VTOL_Only::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&popup);
	Auto_Save_Variable(2,1,&attack);
}
void JFW_Base_Defence_Animated_Sound_No_VTOL_Secondary::Created(GameObject * obj)
{
	popup = false;
	attack = false;
	primary = true;
	Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,0,false);
	Commands->Enable_Enemy_Seen(obj,true);
}
void JFW_Base_Defence_Animated_Sound_No_VTOL_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (!Is_VTOLVehicle(seen))
	{
		if (popup == false)
		{
			popup = true;
			Commands->Start_Timer(obj,this,Get_Float_Parameter("PopupTime"),2);
			Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,Get_Float_Parameter("LastFrame"),false);
			Commands->Create_Sound(Get_Parameter("Sound"),Commands->Get_Position(seen),obj);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("AttackTimer"),1);
		}
		else if (attack == true)
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack_Hold(seen,Get_Float_Parameter("MaxAttackDistance"),0,primary,false);
			Commands->Action_Attack(obj,params);
			if (primary == true)
			{
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Base_Defence_Animated_Sound_No_VTOL_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}
void JFW_Base_Defence_Animated_Sound_No_VTOL_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		popup = false;
		attack = false;
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,Get_Float_Parameter("LastFrame"),0,false);
		Commands->Action_Reset(obj,100);
	}
	if (number == 2)
	{
		attack = true;
	}
}
void JFW_Base_Defence_Animated_Sound_No_VTOL_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&popup);
	Auto_Save_Variable(2,1,&primary);
	Auto_Save_Variable(3,1,&attack);
}
void JFW_Base_Defence_Animated_Sound_VTOL_Only_Secondary::Created(GameObject * obj)
{
	popup = false;
	attack = false;
	primary = true;
	Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,0,false);
	Commands->Enable_Enemy_Seen(obj,true);
}
void JFW_Base_Defence_Animated_Sound_VTOL_Only_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (Is_VTOLVehicle(seen))
	{
		if (popup == false)
		{
			popup = true;
			Commands->Start_Timer(obj,this,Get_Float_Parameter("PopupTime"),2);
			Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,0,Get_Float_Parameter("LastFrame"),false);
			Commands->Create_Sound(Get_Parameter("Sound"),Commands->Get_Position(seen),obj);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("AttackTimer"),1);
		}
		else if (attack == true)
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack_Hold(seen,Get_Float_Parameter("MaxAttackDistance"),0,primary,false);
			Commands->Action_Attack(obj,params);
			if (primary == true)
			{	
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Base_Defence_Animated_Sound_VTOL_Only_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}
void JFW_Base_Defence_Animated_Sound_VTOL_Only_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		popup = false;
		attack = false;
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,NULL,Get_Float_Parameter("LastFrame"),0,false);
		Commands->Action_Reset(obj,100);
	}
	if (number == 2)
	{
		attack = true;
	}
}
void JFW_Base_Defence_Animated_Sound_VTOL_Only_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&popup);
	Auto_Save_Variable(2,1,&primary);
	Auto_Save_Variable(3,1,&attack);
}
void JFW_Building_Gun_Animated_Sound::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("EffectPreset"),Get_Parameter("EffectAnimation"),Get_Parameter("EffectTime"),Get_Parameter("EffectFrame"),Get_Parameter("Sound"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Animated_Sound_Weapon",params);
	}
}
void JFW_Building_Gun_Animated_Sound::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_Animated_Sound::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Animated_Sound::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Animated_Sound_Weapon::Created(GameObject * obj)
{
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
	enemyseen = true;
	attackid = 0;
	GameObject *effect = Commands->Create_Object(Get_Parameter("EffectPreset"),Commands->Get_Position(obj));
	if (effect != 0)
	{
		effectid = Commands->Get_ID(effect);
		lastframe = false;
		Commands->Set_Animation(effect,Get_Parameter("EffectAnimation"),false,NULL,0,0,false);
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		Commands->Enable_Enemy_Seen(obj,false);
		enemyseen = false;
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	float minrange;
	float maxrange;
	float range;
	minrange = Get_Float_Parameter("Min_Range");
	maxrange = Get_Float_Parameter("Max_Range");
	Vector3 pos,pos2;
	pos = Commands->Get_Position(obj);
	pos2 = Commands->Get_Position(seen);
	range = Commands->Get_Distance(pos,pos2);
	pos.Z = 0;
	pos2.Z = 0;
	if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
	{
		enemyseen = false;
		Commands->Enable_Enemy_Seen(obj,false);
		attackid = Commands->Get_ID(seen);
		if (lastframe == false)
		{
			lastframe = true;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,0,Get_Float_Parameter("EffectFrame"),false);
			Commands->Create_Sound(Get_Parameter("Sound"),pos2,obj);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("EffectTime"),1);
		}
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	enemyseen = true;
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Action_Reset(obj,100);
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_Aircraft::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	enemyseen = true;
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Action_Reset(obj,100);
}
void JFW_Building_Gun_Animated_Sound_Weapon_Aircraft_Only::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	enemyseen = true;
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Action_Reset(obj,100);
}
void JFW_Building_Gun_Animated_Sound_Weapon_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	enemyseen = true;
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Action_Reset(obj,100);
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_Aircraft_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	enemyseen = true;
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Action_Reset(obj,100);
}
void JFW_Building_Gun_Animated_Sound_Weapon_Aircraft_Only_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	enemyseen = true;
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Action_Reset(obj,100);
}
void JFW_Building_Gun_Animated_Sound_Weapon::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(Commands->Find_Object(attackid));
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if (lastframe == true)
		{
			lastframe = false;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,Get_Float_Parameter("EffectFrame"),0,false);
		}
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(Commands->Find_Object(attackid),maxrange,0,true);
			Commands->Action_Attack(obj,params);
		}
	}
}
void JFW_Building_Gun_Animated_Sound_No_Aircraft::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("Preset1"),Get_Parameter("Preset2"),Get_Parameter("Preset3"),Get_Parameter("Preset4"),Get_Parameter("Preset5"),Get_Parameter("Preset6"),Get_Parameter("Preset7"),Get_Parameter("Preset8"),Get_Parameter("EffectPreset"),Get_Parameter("EffectAnimation"),Get_Parameter("EffectTime"),Get_Parameter("EffectFrame"),Get_Parameter("Sound"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Animated_Sound_Weapon_No_Aircraft",params);
	}
}
void JFW_Building_Gun_Animated_Sound_No_Aircraft::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_Animated_Sound_No_Aircraft::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Animated_Sound_No_Aircraft::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_Aircraft::Created(GameObject * obj)
{
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
	attackid = 0;
	GameObject *effect = Commands->Create_Object(Get_Parameter("EffectPreset"),Commands->Get_Position(obj));
	if (effect != 0)
	{
		effectid = Commands->Get_ID(effect);
		lastframe = false;
		Commands->Set_Animation(effect,Get_Parameter("EffectAnimation"),false,NULL,0,0,false);
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_Aircraft::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		Commands->Enable_Enemy_Seen(obj,false);
		enemyseen = false;
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_Aircraft::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) != 0))
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			enemyseen = false;
			Commands->Enable_Enemy_Seen(obj,false);
			attackid = Commands->Get_ID(seen);
			if (lastframe == false)
			{
				lastframe = true;
				Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,0,Get_Float_Parameter("EffectFrame"),false);
				Commands->Create_Sound(Get_Parameter("Sound"),pos2,obj);
				Commands->Start_Timer(obj,this,Get_Float_Parameter("EffectTime"),1);
			}
		}
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_Aircraft::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(Commands->Find_Object(attackid));
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if (lastframe == true)
		{
			lastframe = false;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,Get_Float_Parameter("EffectFrame"),0,false);
		}
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(Commands->Find_Object(attackid),maxrange,0,true);
			Commands->Action_Attack(obj,params);
		}
	}
}
void JFW_Building_Gun_Animated_Sound_Aircraft_Only::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("Preset1"),Get_Parameter("Preset2"),Get_Parameter("Preset3"),Get_Parameter("Preset4"),Get_Parameter("Preset5"),Get_Parameter("Preset6"),Get_Parameter("Preset7"),Get_Parameter("Preset8"),Get_Parameter("EffectPreset"),Get_Parameter("EffectAnimation"),Get_Parameter("EffectTime"),Get_Parameter("EffectFrame"),Get_Parameter("Sound"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Animated_Sound_Weapon_Aircraft_Only",params);
	}
}
void JFW_Building_Gun_Animated_Sound_Aircraft_Only::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_Animated_Sound_Aircraft_Only::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Animated_Sound_Aircraft_Only::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Animated_Sound_Weapon_Aircraft_Only::Created(GameObject * obj)
{
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
	enemyseen = true;
	attackid = 0;
	GameObject *effect = Commands->Create_Object(Get_Parameter("EffectPreset"),Commands->Get_Position(obj));
	if (effect != 0)
	{
		effectid = Commands->Get_ID(effect);
		lastframe = false;
		Commands->Set_Animation(effect,Get_Parameter("EffectAnimation"),false,NULL,0,0,false);
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_Aircraft_Only::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		Commands->Enable_Enemy_Seen(obj,false);
		enemyseen = false;
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_Aircraft_Only::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) == 0))
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			enemyseen = false;
			Commands->Enable_Enemy_Seen(obj,false);
			attackid = Commands->Get_ID(seen);
			if (lastframe == false)
			{
				lastframe = true;
				Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,0,Get_Float_Parameter("EffectFrame"),false);
				Commands->Create_Sound(Get_Parameter("Sound"),pos2,obj);
				Commands->Start_Timer(obj,this,Get_Float_Parameter("EffectTime"),1);
			}
		}
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_Aircraft_Only::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(Commands->Find_Object(attackid));
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if (lastframe == true)
		{
			lastframe = false;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,Get_Float_Parameter("EffectFrame"),0,false);
		}
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(Commands->Find_Object(attackid),maxrange,0,true);
			Commands->Action_Attack(obj,params);
		}
	}
}
void JFW_Building_Gun_Animated_Sound_Secondary::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("EffectPreset"),Get_Parameter("EffectAnimation"),Get_Parameter("EffectTime"),Get_Parameter("EffectFrame"),Get_Parameter("Sound"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Animated_Sound_Weapon_Secondary",params);
	}
}
void JFW_Building_Gun_Animated_Sound_Secondary::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_Animated_Sound_Secondary::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Animated_Sound_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Animated_Sound_Weapon_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&primary);
	Auto_Save_Variable(2,4,&effectid);
	Auto_Save_Variable(3,4,&attackid);
	Auto_Save_Variable(4,1,&enemyseen);
	Auto_Save_Variable(5,1,&lastframe);
}
void JFW_Building_Gun_Animated_Sound_Weapon::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&effectid);
	Auto_Save_Variable(2,4,&attackid);
	Auto_Save_Variable(3,1,&enemyseen);
	Auto_Save_Variable(4,1,&lastframe);
}
void JFW_Building_Gun_Animated_Sound_Weapon_Secondary::Created(GameObject * obj)
{
	primary = true;
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
	enemyseen = true;
	attackid = 0;
	GameObject *effect = Commands->Create_Object(Get_Parameter("EffectPreset"),Commands->Get_Position(obj));
	if (effect != 0)
	{
		effectid = Commands->Get_ID(effect);
		lastframe = false;
		Commands->Set_Animation(effect,Get_Parameter("EffectAnimation"),false,NULL,0,0,false);
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_Secondary::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		Commands->Enable_Enemy_Seen(obj,false);
		enemyseen = false;
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	float minrange;
	float maxrange;
	float range;
	minrange = Get_Float_Parameter("Min_Range");
	maxrange = Get_Float_Parameter("Max_Range");
	Vector3 pos,pos2;
	pos = Commands->Get_Position(obj);
	pos2 = Commands->Get_Position(seen);
	range = Commands->Get_Distance(pos,pos2);
	pos.Z = 0;
	pos2.Z = 0;
	if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
	{
		enemyseen = false;
		Commands->Enable_Enemy_Seen(obj,false);
		attackid = Commands->Get_ID(seen);
		if (lastframe == false)
		{
			lastframe = true;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,0,Get_Float_Parameter("EffectFrame"),false);
			Commands->Create_Sound(Get_Parameter("Sound"),pos2,obj);
			Commands->Start_Timer(obj,this,Get_Float_Parameter("EffectTime"),1);
		}
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(Commands->Find_Object(attackid));
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if (lastframe == true)
		{
			lastframe = false;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,Get_Float_Parameter("EffectFrame"),0,false);
		}
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(Commands->Find_Object(attackid),maxrange,0,primary);
			Commands->Action_Attack(obj,params);
			if (primary == true)
			{
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Building_Gun_Animated_Sound_No_Aircraft_Secondary::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("Preset1"),Get_Parameter("Preset2"),Get_Parameter("Preset3"),Get_Parameter("Preset4"),Get_Parameter("Preset5"),Get_Parameter("Preset6"),Get_Parameter("Preset7"),Get_Parameter("Preset8"),Get_Parameter("EffectPreset"),Get_Parameter("EffectAnimation"),Get_Parameter("EffectTime"),Get_Parameter("EffectFrame"),Get_Parameter("Sound"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Animated_Sound_Weapon_No_Aircraft_Secondary",params);
	}
}
void JFW_Building_Gun_Animated_Sound_No_Aircraft_Secondary::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_Animated_Sound_No_Aircraft_Secondary::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Animated_Sound_No_Aircraft_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_Aircraft_Secondary::Created(GameObject * obj)
{
	primary = true;
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
	enemyseen = true;
	attackid = 0;
	GameObject *effect = Commands->Create_Object(Get_Parameter("EffectPreset"),Commands->Get_Position(obj));
	if (effect != 0)
	{
		effectid = Commands->Get_ID(effect);
		lastframe = false;
		Commands->Set_Animation(effect,Get_Parameter("EffectAnimation"),false,NULL,0,0,false);
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_Aircraft_Secondary::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		Commands->Enable_Enemy_Seen(obj,false);
		enemyseen = false;
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_Aircraft_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) != 0) && (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) != 0))
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			enemyseen = false;
			Commands->Enable_Enemy_Seen(obj,false);
			attackid = Commands->Get_ID(seen);
			if (lastframe == false)
			{
				lastframe = true;
				Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,0,Get_Float_Parameter("EffectFrame"),false);
				Commands->Create_Sound(Get_Parameter("Sound"),pos2,obj);
				Commands->Start_Timer(obj,this,Get_Float_Parameter("EffectTime"),1);
			}
		}
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_Aircraft_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(Commands->Find_Object(attackid));
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if (lastframe == true)
		{
			lastframe = false;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,Get_Float_Parameter("EffectFrame"),0,false);
		}
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(Commands->Find_Object(attackid),maxrange,0,primary);
			Commands->Action_Attack(obj,params);
			if (primary == true)
			{
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Building_Gun_Animated_Sound_Aircraft_Only_Secondary::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("Preset1"),Get_Parameter("Preset2"),Get_Parameter("Preset3"),Get_Parameter("Preset4"),Get_Parameter("Preset5"),Get_Parameter("Preset6"),Get_Parameter("Preset7"),Get_Parameter("Preset8"),Get_Parameter("EffectPreset"),Get_Parameter("EffectAnimation"),Get_Parameter("EffectTime"),Get_Parameter("EffectFrame"),Get_Parameter("Sound"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Animated_Sound_Weapon_Aircraft_Only_Secondary",params);
	}
}
void JFW_Building_Gun_Animated_Sound_Aircraft_Only_Secondary::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_Animated_Sound_Aircraft_Only_Secondary::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Animated_Sound_Aircraft_Only_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Animated_Sound_Weapon_Aircraft_Only_Secondary::Created(GameObject * obj)
{
	primary = true;
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
	enemyseen = true;
	attackid = 0;
	GameObject *effect = Commands->Create_Object(Get_Parameter("EffectPreset"),Commands->Get_Position(obj));
	if (effect != 0)
	{
		effectid = Commands->Get_ID(effect);
		lastframe = false;
		Commands->Set_Animation(effect,Get_Parameter("EffectAnimation"),false,NULL,0,0,false);
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_Aircraft_Only_Secondary::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		Commands->Enable_Enemy_Seen(obj,false);
		enemyseen = false;
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_Aircraft_Only_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if ((stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset1")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset2")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset3")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset4")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset5")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset6")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset7")) == 0) || (stricmp(Commands->Get_Preset_Name(seen),Get_Parameter("Preset8")) == 0))
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			enemyseen = false;
			Commands->Enable_Enemy_Seen(obj,false);
			attackid = Commands->Get_ID(seen);
			if (lastframe == false)
			{
				lastframe = true;
				Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,0,Get_Float_Parameter("EffectFrame"),false);
				Commands->Create_Sound(Get_Parameter("Sound"),pos2,obj);
				Commands->Start_Timer(obj,this,Get_Float_Parameter("EffectTime"),1);
			}
		}
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_Aircraft_Only_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(Commands->Find_Object(attackid));
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if (lastframe == true)
		{
			lastframe = false;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,Get_Float_Parameter("EffectFrame"),0,false);
		}
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(Commands->Find_Object(attackid),maxrange,0,primary);
			Commands->Action_Attack(obj,params);
			if (primary == true)
			{
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_Aircraft::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&effectid);
	Auto_Save_Variable(2,4,&attackid);
	Auto_Save_Variable(3,1,&enemyseen);
	Auto_Save_Variable(4,1,&lastframe);
}
void JFW_Building_Gun_Animated_Sound_Weapon_Aircraft_Only::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&effectid);
	Auto_Save_Variable(2,4,&attackid);
	Auto_Save_Variable(3,1,&enemyseen);
	Auto_Save_Variable(4,1,&lastframe);
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_Aircraft_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&primary);
	Auto_Save_Variable(2,4,&effectid);
	Auto_Save_Variable(3,4,&attackid);
	Auto_Save_Variable(4,1,&enemyseen);
	Auto_Save_Variable(5,1,&lastframe);
}
void JFW_Building_Gun_Animated_Sound_Weapon_Aircraft_Only_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&primary);
	Auto_Save_Variable(2,4,&effectid);
	Auto_Save_Variable(3,4,&attackid);
	Auto_Save_Variable(4,1,&enemyseen);
	Auto_Save_Variable(5,1,&lastframe);
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_VTOL::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	enemyseen = true;
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Action_Reset(obj,100);
}
void JFW_Building_Gun_Animated_Sound_Weapon_VTOL_Only::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	enemyseen = true;
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Action_Reset(obj,100);
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_VTOL_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	enemyseen = true;
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Action_Reset(obj,100);
}
void JFW_Building_Gun_Animated_Sound_Weapon_VTOL_Only_Secondary::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	enemyseen = true;
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Action_Reset(obj,100);
}
void JFW_Building_Gun_Animated_Sound_No_VTOL::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("EffectPreset"),Get_Parameter("EffectAnimation"),Get_Parameter("EffectTime"),Get_Parameter("EffectFrame"),Get_Parameter("Sound"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Animated_Sound_Weapon_No_VTOL",params);
	}
}
void JFW_Building_Gun_Animated_Sound_No_VTOL::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_Animated_Sound_No_VTOL::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Animated_Sound_No_VTOL::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_VTOL::Created(GameObject * obj)
{
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
	attackid = 0;
	GameObject *effect = Commands->Create_Object(Get_Parameter("EffectPreset"),Commands->Get_Position(obj));
	if (effect != 0)
	{
		effectid = Commands->Get_ID(effect);
		lastframe = false;
		Commands->Set_Animation(effect,Get_Parameter("EffectAnimation"),false,NULL,0,0,false);
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_VTOL::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		Commands->Enable_Enemy_Seen(obj,false);
		enemyseen = false;
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_VTOL::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (!Is_VTOLVehicle(seen))
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			enemyseen = false;
			Commands->Enable_Enemy_Seen(obj,false);
			attackid = Commands->Get_ID(seen);
			if (lastframe == false)
			{
				lastframe = true;
				Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,0,Get_Float_Parameter("EffectFrame"),false);
				Commands->Create_Sound(Get_Parameter("Sound"),pos2,obj);
				Commands->Start_Timer(obj,this,Get_Float_Parameter("EffectTime"),1);
			}
		}
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_VTOL::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(Commands->Find_Object(attackid));
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if (lastframe == true)
		{
			lastframe = false;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,Get_Float_Parameter("EffectFrame"),0,false);
		}
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(Commands->Find_Object(attackid),maxrange,0,true);
			Commands->Action_Attack(obj,params);
		}
	}
}
void JFW_Building_Gun_Animated_Sound_VTOL_Only::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("EffectPreset"),Get_Parameter("EffectAnimation"),Get_Parameter("EffectTime"),Get_Parameter("EffectFrame"),Get_Parameter("Sound"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Animated_Sound_Weapon_VTOL_Only",params);
	}
}
void JFW_Building_Gun_Animated_Sound_VTOL_Only::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_Animated_Sound_VTOL_Only::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Animated_Sound_VTOL_Only::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Animated_Sound_Weapon_VTOL_Only::Created(GameObject * obj)
{
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
	enemyseen = true;
	attackid = 0;
	GameObject *effect = Commands->Create_Object(Get_Parameter("EffectPreset"),Commands->Get_Position(obj));
	if (effect != 0)
	{
		effectid = Commands->Get_ID(effect);
		lastframe = false;
		Commands->Set_Animation(effect,Get_Parameter("EffectAnimation"),false,NULL,0,0,false);
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_VTOL_Only::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		Commands->Enable_Enemy_Seen(obj,false);
		enemyseen = false;
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_VTOL_Only::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (Is_VTOLVehicle(seen))
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			enemyseen = false;
			Commands->Enable_Enemy_Seen(obj,false);
			attackid = Commands->Get_ID(seen);
			if (lastframe == false)
			{
				lastframe = true;
				Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,0,Get_Float_Parameter("EffectFrame"),false);
				Commands->Create_Sound(Get_Parameter("Sound"),pos2,obj);
				Commands->Start_Timer(obj,this,Get_Float_Parameter("EffectTime"),1);
			}
		}
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_VTOL_Only::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(Commands->Find_Object(attackid));
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if (lastframe == true)
		{
			lastframe = false;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,Get_Float_Parameter("EffectFrame"),0,false);
		}
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(Commands->Find_Object(attackid),maxrange,0,true);
			Commands->Action_Attack(obj,params);
		}
	}
}
void JFW_Building_Gun_Animated_Sound_No_VTOL_Secondary::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("EffectPreset"),Get_Parameter("EffectAnimation"),Get_Parameter("EffectTime"),Get_Parameter("EffectFrame"),Get_Parameter("Sound"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Animated_Sound_Weapon_No_VTOL_Secondary",params);
	}
}
void JFW_Building_Gun_Animated_Sound_No_VTOL_Secondary::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_Animated_Sound_No_VTOL_Secondary::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0))
			{
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Animated_Sound_No_VTOL_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_VTOL_Secondary::Created(GameObject * obj)
{
	primary = true;
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
	enemyseen = true;
	attackid = 0;
	GameObject *effect = Commands->Create_Object(Get_Parameter("EffectPreset"),Commands->Get_Position(obj));
	if (effect != 0)
	{
		effectid = Commands->Get_ID(effect);
		lastframe = false;
		Commands->Set_Animation(effect,Get_Parameter("EffectAnimation"),false,NULL,0,0,false);
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_VTOL_Secondary::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		Commands->Enable_Enemy_Seen(obj,false);
		enemyseen = false;
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_VTOL_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (!Is_VTOLVehicle(seen))
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			enemyseen = false;
			Commands->Enable_Enemy_Seen(obj,false);
			attackid = Commands->Get_ID(seen);
			if (lastframe == false)
			{
				lastframe = true;
				Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,0,Get_Float_Parameter("EffectFrame"),false);
				Commands->Create_Sound(Get_Parameter("Sound"),pos2,obj);
				Commands->Start_Timer(obj,this,Get_Float_Parameter("EffectTime"),1);
			}
		}
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_VTOL_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(Commands->Find_Object(attackid));
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if (lastframe == true)
		{
			lastframe = false;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,Get_Float_Parameter("EffectFrame"),0,false);
		}
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(Commands->Find_Object(attackid),maxrange,0,primary);
			Commands->Action_Attack(obj,params);
			if (primary == true)
			{
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Building_Gun_Animated_Sound_VTOL_Only_Secondary::Created(GameObject * obj)
{
	Vector3 v,v2;
	GameObject * object;
	const char *weapon;
	char params[1000];
	v = Commands->Get_Position(obj);
	v2 = Get_Vector3_Parameter("Positon");
	v.X += v2.X;
	v.Y += v2.Y;
	v.Z += v2.Z;
	weapon = Get_Parameter("Weapon");
	object = Commands->Create_Object(weapon,v);
	if (object != 0)
	{
		Commands->Start_Timer(obj,this,1.0,1);
		weaponid = Commands->Get_ID(object);
		sprintf(params,"%s,%s,%s,%s,%s,%s,%s,%s,%s",Get_Parameter("Disable_Custom"),Get_Parameter("Visible"),Get_Parameter("Min_Range"),Get_Parameter("Max_Range"),Get_Parameter("EffectPreset"),Get_Parameter("EffectAnimation"),Get_Parameter("EffectTime"),Get_Parameter("EffectFrame"),Get_Parameter("Sound"));
		Commands->Attach_Script(object,"JFW_Building_Gun_Animated_Sound_Weapon_VTOL_Only_Secondary",params);
	}
}
void JFW_Building_Gun_Animated_Sound_VTOL_Only_Secondary::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	object = Commands->Find_Object(weaponid);
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (object != 0)
	{
		Commands->Send_Custom_Event(obj,object,x,0,0);
	}
}
void JFW_Building_Gun_Animated_Sound_VTOL_Only_Secondary::Timer_Expired(GameObject * obj,int number)
{
	float health;
	bool power;
	GameObject * object;
	int x;
	x = Get_Int_Parameter("Disable_Custom");
	if (number == 1)
	{
		health = Commands->Get_Health(obj);
		power = Commands->Get_Building_Power(obj);
		object = Commands->Find_Object(weaponid);
		if (object != 0)
		{
			if ((power == false) || (health == 0)){
				Commands->Send_Custom_Event(obj,object,x,0,0);
			}
		}
		Commands->Start_Timer(obj,this,1.0,1);
	}
}
void JFW_Building_Gun_Animated_Sound_VTOL_Only_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&weaponid);
}
void JFW_Building_Gun_Animated_Sound_Weapon_VTOL_Only_Secondary::Created(GameObject * obj)
{
	primary = true;
	int visible;
	visible = Get_Int_Parameter("Visible");
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	Commands->Set_Is_Rendered(obj,visible);
	enemyseen = true;
	attackid = 0;
	GameObject *effect = Commands->Create_Object(Get_Parameter("EffectPreset"),Commands->Get_Position(obj));
	if (effect != 0)
	{
		effectid = Commands->Get_ID(effect);
		lastframe = false;
		Commands->Set_Animation(effect,Get_Parameter("EffectAnimation"),false,NULL,0,0,false);
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_VTOL_Only_Secondary::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Disable_Custom");
	if (message == msg)
	{
		Commands->Enable_Enemy_Seen(obj,false);
		enemyseen = false;
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_VTOL_Only_Secondary::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	GameObject *o = Get_Vehicle(seen);
	if (o != 0)
	{
		seen = o;
	}
	if (!Is_VTOLVehicle(seen))
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			enemyseen = false;
			Commands->Enable_Enemy_Seen(obj,false);
			attackid = Commands->Get_ID(seen);
			if (lastframe == false)
			{
				lastframe = true;
				Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,0,Get_Float_Parameter("EffectFrame"),false);
				Commands->Create_Sound(Get_Parameter("Sound"),pos2,obj);
				Commands->Start_Timer(obj,this,Get_Float_Parameter("EffectTime"),1);
			}
		}
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_VTOL_Only_Secondary::Timer_Expired(GameObject * obj,int number)
{
	if (number == 1)
	{
		float minrange;
		float maxrange;
		float range;
		minrange = Get_Float_Parameter("Min_Range");
		maxrange = Get_Float_Parameter("Max_Range");
		Vector3 pos,pos2;
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(Commands->Find_Object(attackid));
		range = Commands->Get_Distance(pos,pos2);
		pos.Z = 0;
		pos2.Z = 0;
		if (lastframe == true)
		{
			lastframe = false;
			Commands->Set_Animation(Commands->Find_Object(effectid),Get_Parameter("EffectAnimation"),false,NULL,Get_Float_Parameter("EffectFrame"),0,false);
		}
		if ((Commands->Get_Distance(pos,pos2) > minrange) && (range < maxrange)) 
		{
			ActionParamsStruct params;
			params.Set_Basic(this,100,1,-1);
			params.Set_Attack(Commands->Find_Object(attackid),maxrange,0,primary);
			Commands->Action_Attack(obj,params);
			if (primary == true)
			{
				primary = false;
			}
			else
			{
				primary = true;
			}
		}
	}
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_VTOL::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&effectid);
	Auto_Save_Variable(2,4,&attackid);
	Auto_Save_Variable(3,1,&enemyseen);
	Auto_Save_Variable(4,1,&lastframe);
}
void JFW_Building_Gun_Animated_Sound_Weapon_VTOL_Only::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&effectid);
	Auto_Save_Variable(2,4,&attackid);
	Auto_Save_Variable(3,1,&enemyseen);
	Auto_Save_Variable(4,1,&lastframe);
}
void JFW_Building_Gun_Animated_Sound_Weapon_No_VTOL_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&primary);
	Auto_Save_Variable(2,4,&effectid);
	Auto_Save_Variable(3,4,&attackid);
	Auto_Save_Variable(4,1,&enemyseen);
	Auto_Save_Variable(5,1,&lastframe);
}
void JFW_Building_Gun_Animated_Sound_Weapon_VTOL_Only_Secondary::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&primary);
	Auto_Save_Variable(2,4,&effectid);
	Auto_Save_Variable(3,4,&attackid);
	Auto_Save_Variable(4,1,&enemyseen);
	Auto_Save_Variable(5,1,&lastframe);
}
void JFW_Death_Send_Custom_ID::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	int message;
	int ID;
	int param;
	ID = Get_Int_Parameter("ID");
	message = Get_Int_Parameter("Message");
	param = Commands->Get_ID(obj);
	object = Commands->Find_Object(ID);
	Commands->Send_Custom_Event(obj,object,message,param,0);
}
void JFW_Death_Send_Custom_Driver_ID::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * object;
	int message;
	int ID;
	int param;
	ID = Get_Int_Parameter("ID");
	message = Get_Int_Parameter("Message");
	param = DriverID;
	object = Commands->Find_Object(ID);
	Commands->Send_Custom_Event(obj,object,message,param,0);
}
void JFW_Death_Send_Custom_Driver_ID::Created(GameObject * obj)
{
	DriverID = 0;
}
void JFW_Death_Send_Custom_Driver_ID::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if(message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		if(DriverID == 0)
		{
			DriverID = Commands->Get_ID(sender);
		}
	}
	if(message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		if(DriverID == Commands->Get_ID(sender))
		{
			DriverID = 0;
		}
	}
}
void JFW_Death_Send_Custom_Driver_ID::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&DriverID);
}
void JFW_Blow_Up_On_Death_Driver::Created(GameObject * obj)
{
	DriverID = 0;
}
void JFW_Blow_Up_On_Death_Driver::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if(message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		if(DriverID == 0)
		{
			DriverID = Commands->Get_ID(sender);
		}
	}
	if(message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		if(DriverID == Commands->Get_ID(sender))
		{
			DriverID = 0;
		}
	}
}
void JFW_Blow_Up_On_Death_Driver::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&DriverID);
}
void JFW_Blow_Up_On_Death_Driver::Killed(GameObject * obj,GameObject * shooter)
{
	Vector3 v;
	const char *c;
	c = Get_Parameter("Explosion");
	v = Commands->Get_Position(obj);
	Commands->Create_Explosion (c, v, Commands->Find_Object(DriverID));
}
void JFW_Random_DriverDeath::Created(GameObject *obj)
{
	Commands->Start_Timer(obj, this, 0.5, 12121);
}

void JFW_Random_DriverDeath::Timer_Expired(GameObject *obj, int number)
{
	if(number == 12121)
	{
		int percent = Commands->Get_Random_Int(0,100);
		if (percent >= Get_Int_Parameter("Percentage"))
		{
			Commands->Apply_Damage(obj, 100, "Death", 0);
		}
	}
}
void JFW_Cinematic_Attack_Position::Created(GameObject * obj)
{
	ActionParamsStruct params;
	int priority = Get_Int_Parameter("Priority");
	Vector3 position = Get_Vector3_Parameter("Position");
	float range = Get_Float_Parameter("Range");
	float deviation = Get_Float_Parameter("Deviation");
	int primary = Get_Int_Parameter("Primary");
	params.Set_Basic(this,priority,40016,-1);
	params.Set_Attack_Position(position,range,deviation,primary);
	Commands->Action_Attack(obj,params);
}
void JFW_Cinematic_Attack_Position::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}
void JFW_Repair_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		float amount = Commands->Get_Health(obj);
		if (amount>0)
		{
			Commands->Set_Health(obj,(amount+Get_Float_Parameter("Health")));
		}
		amount = Commands->Get_Health(obj);
		if (amount>0)
		{
			Commands->Set_Shield_Strength(obj,(amount+Get_Float_Parameter("Health")));
		}
	}
}
void JFW_Conyard_Vehicle_Buildings::Created(GameObject * obj)
{
	disabled = false;
	Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNum"));
}
void JFW_Conyard_Vehicle_Buildings::Killed(GameObject * obj,GameObject * shooter)
{
	disabled = true;
}
void JFW_Conyard_Vehicle_Buildings::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("DisableCustom"))
	{
		disabled = true;
	}
}
void JFW_Conyard_Vehicle_Buildings::Timer_Expired(GameObject * obj,int number)
{
	if (disabled == false)
	{
		Repair_All_Buildings_By_Team(Get_Object_Type(obj),Commands->Get_ID(obj),Get_Float_Parameter("Health"));
		Repair_All_Static_Vehicles_By_Team(Get_Object_Type(obj),Get_Int_Parameter("Message"));
		Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNum"));
	}
}
void JFW_Conyard_Vehicle_Buildings::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&disabled);
}
void JFW_Gate_Zone_2::Entered(GameObject * obj,GameObject * enter)
{
	int Player_Type = Get_Int_Parameter("Player_Type");
	int ID = Get_Int_Parameter("ID");
	const char *Animation = Get_Parameter("Animation");
	int TimerNum = Get_Int_Parameter("TimerNum");
	float Time = Get_Float_Parameter("Time");
	if (CheckPlayerType(enter,Player_Type) != 0)
	{
		return;
	}
	Commands->Set_Animation(Commands->Find_Object(ID),Animation,false,0,0,-1,false);
	Commands->Start_Timer(obj,this,Time,TimerNum);
}
void JFW_Gate_Zone_2::Timer_Expired(GameObject * obj,int number)
{
	int ID = Get_Int_Parameter("ID");
	const char *Animation = Get_Parameter("Animation");
	int TimerNum = Get_Int_Parameter("TimerNum");
	if (TimerNum == number)
	{
		Commands->Set_Animation(Commands->Find_Object(ID),Animation,false,0,Get_Animation_Frame(Commands->Find_Object(ID)),0,false);
	}
}
void JFW_Animated_Effect::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Vector3 pos = Get_Vector3_Parameter("Location");
		GameObject *object = Commands->Create_Object("Generic_Cinematic",pos);
		Commands->Set_Model(object,Get_Parameter("Model"));
		const char *subobject = Get_Parameter("Subobject");
		if(stricmp(subobject,"0") == 0)
		{
			subobject = 0;
		}
		float firstframe = Get_Float_Parameter("FirstFrame");
		Commands->Set_Animation(object,Get_Parameter("Animation"),false,subobject,firstframe,Get_Float_Parameter("LastFrame"),Get_Int_Parameter("Blended"));
	}
}
void JFW_Animated_Effect_2::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
		Vector3 pos = Commands->Get_Position(obj);
		GameObject *object = Commands->Create_Object("Generic_Cinematic",pos);
		Commands->Set_Model(object,Get_Parameter("Model"));
		const char *subobject = Get_Parameter("Subobject");
		if(stricmp(subobject,"0") == 0)
		{
			subobject = 0;
		}
		float firstframe = Get_Float_Parameter("FirstFrame");
		Commands->Set_Animation(object,Get_Parameter("Animation"),false,subobject,firstframe,Get_Float_Parameter("LastFrame"),Get_Int_Parameter("Blended"));
}
void JFW_Random_Animated_Effect::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Vector3 pos = Get_Vector3_Parameter("Location");
		Vector3 offset = Get_Vector3_Parameter("Offset");
		pos.X += Commands->Get_Random(-offset.X,offset.X);
		pos.Y += Commands->Get_Random(-offset.Y,offset.Y);
		pos.Z += Commands->Get_Random(-offset.Z,offset.Z);
		GameObject *object = Commands->Create_Object("Generic_Cinematic",pos);
		Commands->Set_Model(object,Get_Parameter("Model"));
		const char *subobject = Get_Parameter("Subobject");
		if(stricmp(subobject,"0") == 0)
		{
			subobject = 0;
		}
		float firstframe = Get_Float_Parameter("FirstFrame");
		Commands->Set_Animation(object,Get_Parameter("Animation"),false,subobject,firstframe,Get_Float_Parameter("LastFrame"),Get_Int_Parameter("Blended"));
	}
}
void JFW_Random_Animated_Effect_2::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
		Vector3 pos = Commands->Get_Position(obj);
		Vector3 offset = Get_Vector3_Parameter("Offset");
		pos.X += Commands->Get_Random(-offset.X,offset.X);
		pos.Y += Commands->Get_Random(-offset.Y,offset.Y);
		pos.Z += Commands->Get_Random(-offset.Z,offset.Z);
		GameObject *object = Commands->Create_Object("Generic_Cinematic",pos);
		Commands->Set_Model(object,Get_Parameter("Model"));
		const char *subobject = Get_Parameter("Subobject");
		if(stricmp(subobject,"0") == 0)
		{
			subobject = 0;
		}
		float firstframe = Get_Float_Parameter("FirstFrame");
		Commands->Set_Animation(object,Get_Parameter("Animation"),false,subobject,firstframe,Get_Float_Parameter("LastFrame"),Get_Int_Parameter("Blended"));
}
void JFW_Animated_Effect::Animation_Complete(GameObject * obj,const char *anim)
{
	Commands->Destroy_Object(obj);
}
void JFW_Animated_Effect_2::Animation_Complete(GameObject * obj,const char *anim)
{
	Commands->Destroy_Object(obj);
}
void JFW_Random_Animated_Effect_2::Animation_Complete(GameObject * obj,const char *anim)
{
	Commands->Destroy_Object(obj);
}
void JFW_Random_Animated_Effect::Animation_Complete(GameObject * obj,const char *anim)
{
	Commands->Destroy_Object(obj);
}
void JFW_2D_Sound_Damage::Created(GameObject * obj)
{
	enabled = true;
}
void JFW_2D_Sound_Damage::Damaged(GameObject * obj,GameObject * damager,float damage)
{
	if (Commands->Get_Health(obj) <= Get_Float_Parameter("Health"))
	{
		if (enabled == true)
		{
			enabled = false;
			Commands->Create_2D_Sound(Get_Parameter("Sound"));
		}
	}
	else
	{
		enabled = true;
	}
}
void JFW_2D_Sound_Damage::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
}
void JFW_3D_Sound_Damage::Created(GameObject * obj)
{
	enabled = true;
}
void JFW_3D_Sound_Damage::Damaged(GameObject * obj,GameObject * damager,float damage)
{
	if (Commands->Get_Health(obj) <= Get_Float_Parameter("Health"))
	{
		if (enabled == true)
		{
			enabled = false;
			Vector3 pos = Commands->Get_Position(obj);
			Vector3 offset = Get_Vector3_Parameter("Offset");
			pos.X += offset.X;
			pos.Y += offset.Y;
			pos.Z += offset.Z;
			Commands->Create_Sound(Get_Parameter("Sound"),pos,obj);
		}
	}
	else
	{
		enabled = true;
	}
}
void JFW_3D_Sound_Damage::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
}
ScriptRegistrant<JFW_Spawn_Timer> JFW_Spawn_Timer_Registrant("JFW_Spawn_Timer","Time:float,TimerNum:int,SpawnCustom:int,TriggerCustom:int,TriggerID:int,SpawnPreset:string,SpawnLocation:Vector3");
ScriptRegistrant<JFW_Death_Destroy_Object_Delay> JFW_Death_Destroy_Object_Delay_Registrant("JFW_Death_Destroy_Object_Delay","ID:int,Time:float,TimerNum:int");
ScriptRegistrant<JFW_Conyard> JFW_Conyard_Registrant("JFW_Conyard","Time:float,TimerNum:int,DisableCustom:int,Health:float");
ScriptRegistrant<JFW_Character_Buy> JFW_Character_Buy_Registrant("JFW_Character_Buy","Preset_Name:string,Cost:int,Player_Type:int");
ScriptRegistrant<JFW_Zone_Character> JFW_Zone_Character_Registrant("JFW_Zone_Character","Preset_Name:string,Player_Type:int");
ScriptRegistrant<JFW_Teleport_Zone_Team> JFW_Teleport_Zone_Team_Registrant("JFW_Teleport_Zone_Team","Location:Vector3,Object_ID=0:int,Player_Type:int");
ScriptRegistrant<JFW_Create_Destroy_Object_On_Enter> JFW_Create_Destroy_Object_On_Enter_Registrant("JFW_Create_Destroy_Object_On_Enter","Location:Vector3,Facing:float,Preset:string,Player_Type:int");
ScriptRegistrant<JFW_Custom_Send_Ordered_Customs> JFW_Custom_Send_Ordered_Customs_Registrant("JFW_Custom_Send_Ordered_Customs","ID1:int,ID2:int,ID3:int,ID4:int,ID5:int,ID6:int,ID7:int,ID8:int,Custom1:int,Custom2:int,Custom3:int,Custom4:int,Custom5:int,Custom6:int,Custom7:int,Custom8:int,WaitCustom:int");
ScriptRegistrant<JFW_Custom_Send_Customs> JFW_Custom_Send_Customs_Registrant("JFW_Custom_Send_Customs","ID1:int,ID2:int,ID3:int,ID4:int,ID5:int,ID6:int,ID7:int,ID8:int,Custom1:int,Custom2:int,Custom3:int,Custom4:int,Custom5:int,Custom6:int,Custom7:int,Custom8:int,WaitCustom:int");
ScriptRegistrant<JFW_Custom_Send_Custom_Multiple_IDs> JFW_Custom_Send_Custom_Multiple_IDs_Registrant("JFW_Custom_Send_Custom_Multiple_IDs","ID1:int,ID2:int,ID3:int,ID4:int,ID5:int,ID6:int,ID7:int,ID8:int,WaitCustom:int,SendCustom:int");
ScriptRegistrant<JFW_Set_Health_On_Custom> JFW_Set_Health_On_Custom_Registrant("JFW_Set_Health_On_Custom","Custom:int,Value:float");
ScriptRegistrant<JFW_Add_Health_On_Custom> JFW_Add_Health_On_Custom_Registrant("JFW_Add_Health_On_Custom","Custom:int,Value:float");
ScriptRegistrant<JFW_Set_Max_Health_On_Custom> JFW_Set_Max_Health_On_Custom_Registrant("JFW_Set_Max_Health_On_Custom","Custom:int,Value:float");
ScriptRegistrant<JFW_Add_Max_Health_On_Custom> JFW_Add_Max_Health_On_Custom_Registrant("JFW_Add_Max_Health_On_Custom","Custom:int,Value:float");
ScriptRegistrant<JFW_Set_Shield_Strength_On_Custom> JFW_Set_Shield_Strength_On_Custom_Registrant("JFW_Set_Shield_Strength_On_Custom","Custom:int,Value:float");
ScriptRegistrant<JFW_Add_Shield_Strength_On_Custom> JFW_Add_Shield_Strength_On_Custom_Registrant("JFW_Add_Shield_Strength_On_Custom","Custom:int,Value:float");
ScriptRegistrant<JFW_Set_Max_Shield_Strength_On_Custom> JFW_Set_Max_Shield_Strength_On_Custom_Registrant("JFW_Set_Max_Shield_Strength_On_Custom","Custom:int,Value:float");
ScriptRegistrant<JFW_Add_Max_Shield_Strength_On_Custom> JFW_Add_Max_Shield_Strength_On_Custom_Registrant("JFW_Add_Max_Shield_Strength_On_Custom","Custom:int,Value:float");
ScriptRegistrant<JFW_Set_Health_On_Custom_Sender> JFW_Set_Health_On_Custom_Sender_Registrant("JFW_Set_Health_On_Custom_Sender","Custom:int,Value:float");
ScriptRegistrant<JFW_Add_Health_On_Custom_Sender> JFW_Add_Health_On_Custom_Sender_Registrant("JFW_Add_Health_On_Custom_Sender","Custom:int,Value:float");
ScriptRegistrant<JFW_Set_Max_Health_On_Custom_Sender> JFW_Set_Max_Health_On_Custom_Sender_Registrant("JFW_Set_Max_Health_On_Custom_Sender","Custom:int,Value:float");
ScriptRegistrant<JFW_Add_Max_Health_On_Custom_Sender> JFW_Add_Max_Health_On_Custom_Sender_Registrant("JFW_Add_Max_Health_On_Custom_Sender","Custom:int,Value:float");
ScriptRegistrant<JFW_Set_Shield_Strength_On_Custom_Sender> JFW_Set_Shield_Strength_On_Custom_Sender_Registrant("JFW_Set_Shield_Strength_On_Custom_Sender","Custom:int,Value:float");
ScriptRegistrant<JFW_Add_Shield_Strength_On_Custom_Sender> JFW_Add_Shield_Strength_On_Custom_Sender_Registrant("JFW_Add_Shield_Strength_On_Custom_Sender","Custom:int,Value:float");
ScriptRegistrant<JFW_Set_Max_Shield_Strength_On_Custom_Sender> JFW_Set_Max_Shield_Strength_On_Custom_Sender_Registrant("JFW_Set_Max_Shield_Strength_On_Custom_Sender","Custom:int,Value:float");
ScriptRegistrant<JFW_Add_Max_Shield_Strength_On_Custom_Sender> JFW_Add_Max_Shield_Strength_On_Custom_Sender_Registrant("JFW_Add_Max_Shield_Strength_On_Custom_Sender","Custom:int,Value:float");
ScriptRegistrant<JFW_Create_Destroy_Object_On_Custom_Death> JFW_Create_Destroy_Object_On_Custom_Death_Registrant("JFW_Create_Destroy_Object_On_Custom_Death","Location:Vector3,Facing:float,Preset:string,CreateMessage:int,DestroyMessage:int");
ScriptRegistrant<JFW_Create_Destroy_Object_On_Custom_Death_Bone> JFW_Create_Destroy_Object_On_Custom_Death_Bone_Registrant("JFW_Create_Destroy_Object_On_Custom_Death_Bone","Location:Vector3,Facing:float,Preset:string,CreateMessage:int,DestroyMessage:int,BoneName:string");
ScriptRegistrant<JFW_Custom_Destroy_All_Buildings> JFW_Custom_Destroy_All_Buildings_Registrant("JFW_Custom_Destroy_All_Buildings","Player_Type:int");
ScriptRegistrant<JFW_Random_Timer_Play_Cinematic> JFW_Random_Timer_Play_Cinematic_Registrant("JFW_Random_Timer_Play_Cinematic","TimeMin:float,TimeMax:float,TimerNum:int,Repeat:int,Script_Name:string,Location:Vector3,Facing:float");
ScriptRegistrant<JFW_Flying_Infantry> JFW_Flying_Infantry_Registrant("JFW_Flying_Infantry","");
ScriptRegistrant<JFW_Flying_Infantry_Custom> JFW_Flying_Infantry_Custom_Registrant("JFW_Flying_Infantry_Custom","Message:int");
ScriptRegistrant<JFW_Flying_Infantry_Powerup> JFW_Flying_Infantry_Powerup_Registrant("JFW_Flying_Infantry_Powerup","");
ScriptRegistrant<JFW_Flying_Infantry_Enter> JFW_Flying_Infantry_Enter_Registrant("JFW_Flying_Infantry_Enter","Player_Type:int");
ScriptRegistrant<JFW_Flying_Infantry_Exit> JFW_Flying_Infantry_Exit_Registrant("JFW_Flying_Infantry_Exit","Player_Type:int");
ScriptRegistrant<JFW_Warp_On_Pickup_Team> JFW_Warp_On_Pickup_Team_Registrant("JFW_Warp_On_Pickup_Team","Position:Vector3,Player_Type:int");
ScriptRegistrant<JFW_Base_Defence_No_VTOL> JFW_Base_Defence_No_VTOL_Registrant("JFW_Base_Defence_No_VTOL","MinAttackDistance=0.0:float,MaxAttackDistance=300.0:float,AttackTimer=10.0:float");
ScriptRegistrant<JFW_Base_Defence_VTOL_Only> JFW_Base_Defence_VTOL_Only_Registrant("JFW_Base_Defence_VTOL_Only","MinAttackDistance=0.0:float,MaxAttackDistance=300.0:float,AttackTimer=10.0:float");
ScriptRegistrant<JFW_Base_Defence_No_VTOL_Secondary> JFW_Base_Defence_No_VTOL_Secondary_Registrant("JFW_Base_Defence_No_VTOL_Secondary","MinAttackDistance=0.0:float,MaxAttackDistance=300.0:float,AttackTimer=10.0:float");
ScriptRegistrant<JFW_Base_Defence_VTOL_Only_Secondary> JFW_Base_Defence_VTOL_Only_Secondary_Registrant("JFW_Base_Defence_VTOL_Only_Secondary","MinAttackDistance=0.0:float,MaxAttackDistance=300.0:float,AttackTimer=10.0:float");
ScriptRegistrant<JFW_Base_Defence_Animated_No_VTOL> JFW_Base_Defence_Animated_No_VTOL_Registrant("JFW_Base_Defence_Animated_No_VTOL","MaxAttackDistance:float,AttackTimer:float,Animation:string,LastFrame:float,PopupTime:float");
ScriptRegistrant<JFW_Base_Defence_Animated_VTOL_Only> JFW_Base_Defence_Animated_VTOL_Only_Registrant("JFW_Base_Defence_Animated_VTOL_Only","MaxAttackDistance:float,AttackTimer:float,Animation:string,LastFrame:float,PopupTime:float");
ScriptRegistrant<JFW_Base_Defence_Animated_No_VTOL_Secondary> JFW_Base_Defence_Animated_No_VTOL_Secondary_Registrant("JFW_Base_Defence_Animated_No_VTOL_Secondary","MaxAttackDistance:float,AttackTimer:float,Animation:string,LastFrame:float,PopupTime:float");
ScriptRegistrant<JFW_Base_Defence_Animated_VTOL_Only_Secondary> JFW_Base_Defence_Animated_VTOL_Only_Secondary_Registrant("JFW_Base_Defence_Animated_VTOL_Only_Secondary","MaxAttackDistance:float,AttackTimer:float,Animation:string,LastFrame:float,PopupTime:float");
ScriptRegistrant<JFW_Building_Gun_No_VTOL> JFW_Building_Gun_No_VTOL_Registrant("JFW_Building_Gun_No_VTOL","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float");
ScriptRegistrant<JFW_Building_Gun_Weapon_No_VTOL> JFW_Building_Gun_Weapon_No_VTOL_Registrant("JFW_Building_Gun_Weapon_No_VTOL","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float");
ScriptRegistrant<JFW_Repair_Zone_No_VTOL> JFW_Repair_Zone_No_VTOL_Registrant("JFW_Repair_Zone_No_VTOL","Player_Type:int,Repair_Distance:float,Repair_Health:float");
ScriptRegistrant<JFW_Building_Gun_No_VTOL_Secondary> JFW_Building_Gun_No_VTOL_Secondary_Registrant("JFW_Building_Gun_No_VTOL_Secondary","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float");
ScriptRegistrant<JFW_Building_Gun_Weapon_No_VTOL_Secondary> JFW_Building_Gun_Weapon_No_VTOL_Secondary_Registrant("JFW_Building_Gun_Weapon_No_VTOL_Secondary","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float");
ScriptRegistrant<JFW_Building_Gun_Animated_No_VTOL> JFW_Building_Gun_Animated_No_VTOL_Registrant("JFW_Building_Gun_Animated_No_VTOL","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float");
ScriptRegistrant<JFW_Building_Gun_Animated_Weapon_No_VTOL> JFW_Building_Gun_Animated_Weapon_No_VTOL_Registrant("JFW_Building_Gun_Animated_Weapon_No_VTOL","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float");
ScriptRegistrant<JFW_Building_Gun_Animated_No_VTOL_Secondary> JFW_Building_Gun_Animated_No_VTOL_Secondary_Registrant("JFW_Building_Gun_Animated_No_VTOL_Secondary","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float");
ScriptRegistrant<JFW_Building_Gun_Animated_Weapon_No_VTOL_Secondary> JFW_Building_Gun_Animated_Weapon_No_VTOL_Secondary_Registrant("JFW_Building_Gun_Animated_Weapon_No_VTOL_Secondary","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float");
ScriptRegistrant<JFW_Building_Gun_VTOL_Only> JFW_Building_Gun_VTOL_Only_Registrant("JFW_Building_Gun_VTOL_Only","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float");
ScriptRegistrant<JFW_Building_Gun_Weapon_VTOL_Only> JFW_Building_Gun_Weapon_VTOL_Only_Registrant("JFW_Building_Gun_Weapon_VTOL_Only","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float");
ScriptRegistrant<JFW_Repair_Zone_VTOL_Only> JFW_Repair_Zone_VTOL_Only_Registrant("JFW_Repair_Zone_VTOL_Only","Player_Type:int,Repair_Distance:float,Repair_Health:float");
ScriptRegistrant<JFW_Building_Gun_VTOL_Only_Secondary> JFW_Building_Gun_VTOL_Only_Secondary_Registrant("JFW_Building_Gun_VTOL_Only_Secondary","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float");
ScriptRegistrant<JFW_Building_Gun_Weapon_VTOL_Only_Secondary> JFW_Building_Gun_Weapon_VTOL_Only_Secondary_Registrant("JFW_Building_Gun_Weapon_VTOL_Only_Secondary","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float");
ScriptRegistrant<JFW_Building_Gun_Animated_VTOL_Only> JFW_Building_Gun_Animated_VTOL_Only_Registrant("JFW_Building_Gun_Animated_VTOL_Only","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float");
ScriptRegistrant<JFW_Building_Gun_Animated_Weapon_VTOL_Only> JFW_Building_Gun_Animated_Weapon_VTOL_Only_Registrant("JFW_Building_Gun_Animated_Weapon_VTOL_Only","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float");
ScriptRegistrant<JFW_Building_Gun_Animated_VTOL_Only_Secondary> JFW_Building_Gun_Animated_VTOL_Only_Secondary_Registrant("JFW_Building_Gun_Animated_VTOL_Only_Secondary","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float");
ScriptRegistrant<JFW_Building_Gun_Animated_Weapon_VTOL_Only_Secondary> JFW_Building_Gun_Animated_Weapon_VTOL_Only_Secondary_Registrant("JFW_Building_Gun_Animated_Weapon_VTOL_Only_Secondary","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float");
ScriptRegistrant<JFW_Refill_Buy> JFW_Refill_Buy_Registrant("JFW_Refill_Buy","Cost:int,Player_Type:int");
ScriptRegistrant<JFW_Vehicle_Buy> JFW_Vehicle_Buy_Registrant("JFW_Vehicle_Buy","Preset_Name:string,Cost:int,Player_Type:int");
ScriptRegistrant<JFW_Powerup_Buy> JFW_Powerup_Buy_Registrant("JFW_Powerup_Buy","Preset_Name:string,Cost:int,Player_Type:int");
ScriptRegistrant<JFW_Refill_Powerup> JFW_Refill_Powerup_Registrant("JFW_Refill_Powerup","");
ScriptRegistrant<JFW_Timer_Custom_On_Off> JFW_Timer_Custom_On_Off_Registrant("JFW_Timer_Custom_On_Off","Time:float,TimerNum:int,Repeat:int,ID:int,Message:int,Param:int,EnableMessage:int,DisableMessage:int");
ScriptRegistrant<JFW_Zone_Weapon> JFW_Zone_Weapon_Registrant("JFW_Zone_Weapon","Weapon_Name:string,Player_Type:int");
ScriptRegistrant<JFW_Zone_Vehicle> JFW_Zone_Vehicle_Registrant("JFW_Zone_Vehicle","Preset_Name:string,Player_Type:int");
ScriptRegistrant<JFW_Zone_Powerup> JFW_Zone_Powerup_Registrant("JFW_Zone_Powerup","Preset_Name:string,Player_Type:int");
ScriptRegistrant<JFW_Zone_Refill> JFW_Zone_Refill_Registrant("JFW_Zone_Refill","Player_Type:int");
ScriptRegistrant<JFW_Timer_Play_Random_Cinematic> JFW_Timer_Play_Random_Cinematic_Registrant("JFW_Timer_Play_Random_Cinematic","Time:float,TimerNum:int,Repeat:int,Script_Name1:string,Script_Name2:string,Script_Name3:string,Script_Name4:string,Script_Name5:string,Location:Vector3,Facing:float");
ScriptRegistrant<JFW_Random_Timer_Play_Random_Cinematic> JFW_Random_Timer_Play_Random_Cinematic_Registrant("JFW_Random_Timer_Play_Random_Cinematic","TimeMin:float,TimeMax:float,TimerNum:int,Repeat:int,Script_Name1:string,Script_Name2:string,Script_Name3:string,Script_Name4:string,Script_Name5:string,Location:Vector3,Facing:float");
ScriptRegistrant<JFW_Vehicle_Powerup> JFW_Vehicle_Powerup_Registrant("JFW_Vehicle_Powerup","Message:int");
ScriptRegistrant<JFW_Vehicle_Powerup_Preset> JFW_Vehicle_Powerup_Preset_Registrant("JFW_Vehicle_Powerup_Preset","Message:int,Preset:string");
ScriptRegistrant<JFW_Create_Vehicle_On_Custom> JFW_Create_Vehicle_On_Custom_Registrant("JFW_Create_Vehicle_On_Custom","Preset_Name:string,Delay:float,Player_Type:int");
ScriptRegistrant<JFW_Powerup_Send_Custom> JFW_Powerup_Send_Custom_Registrant("JFW_Powerup_Send_Custom","ID:int,Message:int");
ScriptRegistrant<JFW_Powerup_Send_Custom_Team> JFW_Powerup_Send_Custom_Team_Registrant("JFW_Powerup_Send_Custom_Team","GDIID:int,GDIMessage:int,NodID:int,NodMessage:int");
ScriptRegistrant<JFW_Zone_Send_Custom_Team> JFW_Zone_Send_Custom_Team_Registrant("JFW_Zone_Send_Custom_Team","GDIID:int,GDIEnterMessage:int,GDIEnterParam:int,GDIExitMessage:int,GDIExitParam:int,NodID:int,NodEnterMessage:int,NodEnterParam:int,NodExitMessage:int,NodExitParam:int");
ScriptRegistrant<JFW_Regenerate_Health_Conditional> JFW_Regenerate_Health_Conditional_Registrant("JFW_Regenerate_Health_Conditional","EnableMessage:int,DisableMessage:int,Amount:int");
ScriptRegistrant<JFW_Drone_Damage> JFW_Drone_Damage_Registrant("JFW_Drone_Damage","RepairStop:int,Preset:string,Amount:int,Custom:int");
ScriptRegistrant<JFW_Vechicle_Animation_2> JFW_Vechicle_Animation_2_Registrant("JFW_Vechicle_Animation_2","Animation:string,Subobject:string,FirstFrame:float,LastFrame:float,Blended:int,Time:float,TimerNum:int,UpAnimation:string,UpSubobject:string,UpFirstFrame:float,UpLastFrame:float,UpBlended:int,DownAnimation:string,DownSubobject:string,DownFirstFrame:float,DownLastFrame:float,DownBlended:int");
ScriptRegistrant<JFW_Zone_Animation> JFW_Zone_Animation_Registrant("JFW_Zone_Animation","Animation:string,Subobject:string,FirstFrame:float,LastFrame:float,Blended:int,UpAnimation:string,UpSubobject:string,UpFirstFrame:float,UpLastFrame:float,UpBlended:int,DownAnimation:string,DownSubobject:string,DownFirstFrame:float,DownLastFrame:float,DownBlended:int,Model:string");
ScriptRegistrant<JFW_Group_Purchase_Zone> JFW_Group_Purchase_Zone_Registrant("JFW_Group_Purchase_Zone","CashPerPerson:float,TotalCash:float,ID:int,Custom:int");
ScriptRegistrant<JFW_Zone_Timer> JFW_Zone_Timer_Registrant("JFW_Zone_Timer","Count:int,ID:int,Custom:int,Time:float,TimerNum:int");
ScriptRegistrant<JFW_Building_Damage> JFW_Building_Damage_Registrant("JFW_Building_Damage","Message:int,Player_Type:int,Damage:float,Warhead:string,Distance:float");
ScriptRegistrant<JFW_Building_Damage_Scale> JFW_Building_Damage_Scale_Registrant("JFW_Building_Damage_Scale","Message:int,Player_Type:int,Damage:float,Warhead:string,Distance:float");
ScriptRegistrant<JFW_Weapon_Change_On_Custom> JFW_Weapon_Change_On_Custom_Registrant("JFW_Weapon_Change_On_Custom","Message:int,Powerup:string,Weapon:string");
ScriptRegistrant<JFW_Weapon_Change_On_Custom_Sender> JFW_Weapon_Change_On_Custom_Sender_Registrant("JFW_Weapon_Change_On_Custom_Sender","Message:int,Powerup:string,Weapon:string");
ScriptRegistrant<JFW_Set_Model_On_Custom_Sender> JFW_Set_Model_On_Custom_Sender_Registrant("JFW_Set_Model_On_Custom_Sender","Message:int,Model:string");
ScriptRegistrant<JFW_Send_Driver_Custom_On_Enter> JFW_Send_Driver_Custom_On_Enter("JFW_Send_Driver_Custom_On_Enter","EnterMessage:int,ExitMessage:int");
ScriptRegistrant<JFW_Weapon_Change_On_Custom_Multiple> JFW_Weapon_Change_On_Custom_Multiple_Registrant("JFW_Weapon_Change_On_Custom_Multiple","Message:int,Powerup1:string,Powerup2:string,Powerup3:string,Powerup4:string,Powerup5:string,Weapon:string");
ScriptRegistrant<JFW_Weapon_Change_On_Custom_Multiple_Sender> JFW_Weapon_Change_On_Custom_Multiple_Sender_Registrant("JFW_Weapon_Change_On_Custom_Multiple_Sender","Message:int,Powerup1:string,Powerup2:string,Powerup3:string,Powerup4:string,Powerup5:string,Weapon:string");
ScriptRegistrant<JFW_Clear_Weapons_On_Custom> JFW_Clear_Weapons_On_Custom_Registrant("JFW_Clear_Weapons_On_Custom","Message:int,Powerup:string,Weapon:string");
ScriptRegistrant<JFW_Base_Defence_Animated_Sound> JFW_Base_Defence_Animated_Sound_Registrant("JFW_Base_Defence_Animated_Sound","MaxAttackDistance:float,AttackTimer:float,Animation:string,LastFrame:float,PopupTime:float,Sound:string");
ScriptRegistrant<JFW_Base_Defence_Animated_Sound_No_Aircraft> JFW_Base_Defence_Animated_Sound_No_Aircraft_Registrant("JFW_Base_Defence_Animated_Sound_No_Aircraft","MaxAttackDistance:float,AttackTimer:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,Animation:string,LastFrame:float,PopupTime:float,Sound:string");
ScriptRegistrant<JFW_Base_Defence_Animated_Sound_Aircraft_Only> JFW_Base_Defence_Animated_Sound_Aircraft_Only_Registrant("JFW_Base_Defence_Animated_Sound_Aircraft_Only","MaxAttackDistance:float,AttackTimer:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,Animation:string,LastFrame:float,PopupTime:float,Sound:string");
ScriptRegistrant<JFW_Base_Defence_Animated_Sound_Secondary> JFW_Base_Defence_Animated_Sound_Secondary_Registrant("JFW_Base_Defence_Animated_Sound_Secondary","MaxAttackDistance:float,AttackTimer:float,Animation:string,LastFrame:float,PopupTime:float,Sound:string");
ScriptRegistrant<JFW_Base_Defence_Animated_Sound_No_Aircraft_Secondary> JFW_Base_Defence_Animated_Sound_No_Aircraft_Secondary_Registrant("JFW_Base_Defence_Animated_Sound_No_Aircraft_Secondary","MaxAttackDistance:float,AttackTimer:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,Animation:string,LastFrame:float,PopupTime:float,Sound:string");
ScriptRegistrant<JFW_Base_Defence_Animated_Sound_Aircraft_Only_Secondary> JFW_Base_Defence_Animated_Sound_Aircraft_Only_Secondary_Registrant("JFW_Base_Defence_Animated_Sound_Aircraft_Only_Secondary","MaxAttackDistance:float,AttackTimer:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,Animation:string,LastFrame:float,PopupTime:float,Sound:string");
ScriptRegistrant<JFW_Base_Defence_Animated_Sound_No_VTOL> JFW_Base_Defence_Animated_Sound_No_VTOL_Registrant("JFW_Base_Defence_Animated_Sound_No_VTOL","MaxAttackDistance:float,AttackTimer:float,Animation:string,LastFrame:float,PopupTime:float,Sound:string");
ScriptRegistrant<JFW_Base_Defence_Animated_Sound_VTOL_Only> JFW_Base_Defence_Animated_Sound_VTOL_Only_Registrant("JFW_Base_Defence_Animated_Sound_VTOL_Only","MaxAttackDistance:float,AttackTimer:float,Animation:string,LastFrame:float,PopupTime:float,Sound:string");
ScriptRegistrant<JFW_Base_Defence_Animated_Sound_No_VTOL_Secondary> JFW_Base_Defence_Animated_Sound_No_VTOL_Secondary_Registrant("JFW_Base_Defence_Animated_Sound_No_VTOL_Secondary","MaxAttackDistance:float,AttackTimer:float,Animation:string,LastFrame:float,PopupTime:float,Sound:string");
ScriptRegistrant<JFW_Base_Defence_Animated_Sound_VTOL_Only_Secondary> JFW_Base_Defence_Animated_Sound_VTOL_Only_Secondary_Registrant("JFW_Base_Defence_Animated_Sound_VTOL_Only_Secondary","MaxAttackDistance:float,AttackTimer:float,Animation:string,LastFrame:float,PopupTime:float,Sound:string");
ScriptRegistrant<JFW_Building_Gun_Animated_Sound_No_VTOL> JFW_Building_Gun_Animated_Sound_No_VTOL_Registrant("JFW_Building_Gun_Animated_Sound_No_VTOL","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float,Sound:string");
ScriptRegistrant<JFW_Building_Gun_Animated_Sound_Weapon_No_VTOL> JFW_Building_Gun_Animated_Sound_Weapon_No_VTOL_Registrant("JFW_Building_Gun_Animated_Sound_Weapon_No_VTOL","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float,Sound:string");
ScriptRegistrant<JFW_Building_Gun_Animated_Sound_No_VTOL_Secondary> JFW_Building_Gun_Animated_Sound_No_VTOL_Secondary_Registrant("JFW_Building_Gun_Animated_Sound_No_VTOL_Secondary","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float,Sound:string");
ScriptRegistrant<JFW_Building_Gun_Animated_Sound_Weapon_No_VTOL_Secondary> JFW_Building_Gun_Animated_Sound_Weapon_No_VTOL_Secondary_Registrant("JFW_Building_Gun_Animated_Sound_Weapon_No_VTOL_Secondary","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float,Sound:string");
ScriptRegistrant<JFW_Building_Gun_Animated_Sound_VTOL_Only> JFW_Building_Gun_Animated_Sound_VTOL_Only_Registrant("JFW_Building_Gun_Animated_Sound_VTOL_Only","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float,Sound:string");
ScriptRegistrant<JFW_Building_Gun_Animated_Sound_Weapon_VTOL_Only> JFW_Building_Gun_Animated_Sound_Weapon_VTOL_Only_Registrant("JFW_Building_Gun_Animated_Sound_Weapon_VTOL_Only","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float,Sound:string");
ScriptRegistrant<JFW_Building_Gun_Animated_Sound_VTOL_Only_Secondary> JFW_Building_Gun_Animated_Sound_VTOL_Only_Secondary_Registrant("JFW_Building_Gun_Animated_Sound_VTOL_Only_Secondary","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float,Sound:string");
ScriptRegistrant<JFW_Building_Gun_Animated_Sound_Weapon_VTOL_Only_Secondary> JFW_Building_Gun_Animated_Sound_Weapon_VTOL_Only_Secondary_Registrant("JFW_Building_Gun_Animated_Sound_Weapon_VTOL_Only_Secondary","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float,Sound:string");
ScriptRegistrant<JFW_Building_Gun_Animated_Sound> JFW_Building_Gun_Animated_Sound_Registrant("JFW_Building_Gun_Animated_Sound","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float,Sound:string");
ScriptRegistrant<JFW_Building_Gun_Animated_Sound_Weapon> JFW_Building_Gun_Animated_Sound_Weapon_Registrant("JFW_Building_Gun_Animated_Sound_Weapon","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float,Sound:string");
ScriptRegistrant<JFW_Building_Gun_Animated_Sound_No_Aircraft> JFW_Building_Gun_Animated_Sound_No_Aircraft_Registrant("JFW_Building_Gun_Animated_Sound_No_Aircraft","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float,Sound:string");
ScriptRegistrant<JFW_Building_Gun_Animated_Sound_Aircraft_Only> JFW_Building_Gun_Animated_Sound_Aircraft_Only_Registrant("JFW_Building_Gun_Animated_Sound_Aircraft_Only","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float,Sound:string");
ScriptRegistrant<JFW_Building_Gun_Animated_Sound_Weapon_No_Aircraft> JFW_Building_Gun_Animated_Sound_Weapon_No_Aircraft_Registrant("JFW_Building_Gun_Animated_Sound_Weapon_No_Aircraft","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float,Sound:string");
ScriptRegistrant<JFW_Building_Gun_Animated_Sound_Weapon_Aircraft_Only> JFW_Building_Gun_Animated_Sound_Weapon_Aircraft_Only_Registrant("JFW_Building_Gun_Animated_Sound_Weapon_Aircraft_Only","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float,Sound:string");
ScriptRegistrant<JFW_Building_Gun_Animated_Sound_Secondary> JFW_Building_Gun_Animated_Sound_Secondary_Registrant("JFW_Building_Gun_Animated_Sound_Secondary","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float,Sound:string");
ScriptRegistrant<JFW_Building_Gun_Animated_Sound_Weapon_Secondary> JFW_Building_Gun_Animated_Sound_Weapon_Secondary_Registrant("JFW_Building_Gun_Animated_Sound_Weapon_Secondary","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float,Sound:string");
ScriptRegistrant<JFW_Building_Gun_Animated_Sound_No_Aircraft_Secondary> JFW_Building_Gun_Animated_Sound_No_Aircraft_Secondary_Registrant("JFW_Building_Gun_Animated_Sound_No_Aircraft_Secondary","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float,Sound:string");
ScriptRegistrant<JFW_Building_Gun_Animated_Sound_Aircraft_Only_Secondary> JFW_Building_Gun_Animated_Sound_Aircraft_Only_Secondary_Registrant("JFW_Building_Gun_Animated_Sound_Aircraft_Only_Secondary","Disable_Custom:int,Positon:Vector3,Weapon:string,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float,Sound:string");
ScriptRegistrant<JFW_Building_Gun_Animated_Sound_Weapon_No_Aircraft_Secondary> JFW_Building_Gun_Animated_Sound_Weapon_No_Aircraft_Secondary_Registrant("JFW_Building_Gun_Animated_Sound_Weapon_No_Aircraft_Secondary","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float,Sound:string");
ScriptRegistrant<JFW_Building_Gun_Animated_Sound_Weapon_Aircraft_Only_Secondary> JFW_Building_Gun_Animated_Sound_Weapon_Aircraft_Only_Secondary_Registrant("JFW_Building_Gun_Animated_Sound_Weapon_Aircraft_Only_Secondary","Disable_Custom:int,Visible:int,Min_Range:float,Max_Range:float,Preset1:string,Preset2:string,Preset3:string,Preset4:string,Preset5:string,Preset6:string,Preset7:string,Preset8:string,EffectPreset:string,EffectAnimation:string,EffectTime:float,EffectFrame:float,Sound:string");
ScriptRegistrant<JFW_Death_Send_Custom_ID> JFW_Death_Send_Custom_ID_Registrant("JFW_Death_Send_Custom_ID","ID:int,Message:int");
ScriptRegistrant<JFW_Death_Send_Custom_Driver_ID> JFW_Death_Send_Custom_Driver_ID_Registrant("JFW_Death_Send_Custom_Driver_ID","ID:int,Message:int");
ScriptRegistrant<JFW_Blow_Up_On_Death_Driver> JFW_Blow_Up_On_Death_Driver_Registrant("JFW_Blow_Up_On_Death_Driver","Explosion:string");
ScriptRegistrant<JFW_Random_DriverDeath> JFW_Random_DriverDeath_Registrant("JFW_Random_DriverDeath", "Percentage:int");
ScriptRegistrant<JFW_Cinematic_Attack_Position> JFW_Cinematic_Attack_Position_Registrant("JFW_Cinematic_Attack_Position","Priority=96:int,Position:Vector3,Range:float,Deviation:float,Primary:int");
ScriptRegistrant<JFW_Repair_On_Custom> JFW_Repair_On_Custom_Registrant("JFW_Repair_On_Custom","Message:int,Health:float");
ScriptRegistrant<JFW_Conyard_Vehicle_Buildings> JFW_Conyard_Vehicle_Buildings_Registrant("JFW_Conyard_Vehicle_Buildings","Time:float,TimerNum:int,DisableCustom:int,Health:float,Message:int");
ScriptRegistrant<JFW_Gate_Zone_2> JFW_Gate_Zone_2_Registrant("JFW_Gate_Zone_2","Player_Type:int,Time:Float,TimerNum:int,ID:int,Animation:string");
ScriptRegistrant<JFW_Animated_Effect> JFW_Animated_Effect_Registrant("JFW_Animated_Effect","Animation:string,Subobject:string,FirstFrame:float,LastFrame:float,Blended:int,Model:string,Message:int,Location:Vector3");
ScriptRegistrant<JFW_Animated_Effect_2> JFW_Animated_Effect_2_Registrant("JFW_Animated_Effect_2","Animation:string,Subobject:string,FirstFrame:float,LastFrame:float,Blended:int,Model:string,Message:int");
ScriptRegistrant<JFW_Random_Animated_Effect> JFW_Random_Animated_Effect_Registrant("JFW_Random_Animated_Effect","Animation:string,Subobject:string,FirstFrame:float,LastFrame:float,Blended:int,Model:string,Message:int,Location:Vector3,Offset:Vector3");
ScriptRegistrant<JFW_Random_Animated_Effect_2> JFW_Random_Animated_Effect_2_Registrant("JFW_Random_Animated_Effect_2","Animation:string,Subobject:string,FirstFrame:float,LastFrame:float,Blended:int,Model:string,Message:int,Offset:Vector3");
ScriptRegistrant<JFW_2D_Sound_Damage> JFW_2D_Sound_Damage("JFW_2D_Sound_Damage","Sound:string,Health:float");
ScriptRegistrant<JFW_3D_Sound_Damage> JFW_3D_Sound_Damage("JFW_3D_Sound_Damage","Sound:string,Health:float,Offset:Vector3");
